/* jce - 2.9.88 | 2025-06-19 | https://www.joomlacontenteditor.net | Source: https://github.com/widgetfactory/jce | Copyright (C) 2006 - 2025 Ryan Demmer. All rights reserved | GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html */
!function() {
    "use strict";
    (function($) {
        document.createElement("main"), document.createElement("nav");
        var s, el, $tmp = document.createElement("div");
        $.support.canvas = !!document.createElement("canvas").getContext, $.support.backgroundSize = (s = !1, 
        $.each([ "backgroundSize", "MozBackgroundSize", "WebkitBackgroundSize", "OBackgroundSize" ], function() {
            void 0 !== $tmp.style[this] && (s = !0);
        }), s), $.support.pdf = function() {
            try {
                if (!$.support.cssFloat) {
                    var control = null;
                    try {
                        control = new ActiveXObject("AcroPDF.PDF");
                    } catch (e) {}
                    if (!control) try {
                        control = new ActiveXObject("PDF.PdfCtrl");
                    } catch (e) {}
                    return !!control;
                }
                if (navigator.plugins) for (var n in navigator.plugins) {
                    if ("Adobe Acrobat" == n) return !0;
                    if (navigator.plugins[n].name && ("Adobe Acrobat" == navigator.plugins[n].name || "Chrome PDF Viewer" == navigator.plugins[n].name)) return !0;
                } else if (navigator.mimeTypes) {
                    var mime = navigator.mimeTypes["application/pdf"];
                    if (mime && mime.enabledPlugin) return !0;
                }
            } catch (e) {}
            return !1;
        }(), $.support.video = function() {
            var h264, el = document.createElement("video"), o = {};
            try {
                if (el.canPlayType) return o.ogg = el.canPlayType('video/ogg; codecs="theora"'), 
                h264 = 'video/mp4; codecs="avc1.42E01E', o.mp4 = el.canPlayType(h264 + '"') || el.canPlayType(h264 + ', mp4a.40.2"'), 
                o.webm = el.canPlayType('video/webm; codecs="vp8, vorbis"'), o;
            } catch (e) {}
            return !1;
        }(), $.support.audio = function() {
            var el = document.createElement("audio"), o = {};
            try {
                if (el.canPlayType) return o.ogg = el.canPlayType('audio/ogg; codecs="vorbis"'), 
                o.mp3 = el.canPlayType("audio/mpeg;"), o.wav = el.canPlayType('audio/wav; codecs="1"'), 
                o.m4a = el.canPlayType("audio/x-m4a;") || el.canPlayType("audio/aac;"), 
                o.webm = el.canPlayType('audio/webm; codecs="vp8, vorbis"'), o;
            } catch (e) {}
            return !1;
        }(), $.support.cssCalc = ((el = document.createElement("a")).style.cssText = "width:calc(10px);", 
        !!el.style.length);
    })(jQuery), function($) {
        $.support.canvas = !1, $.fn.tips = function(options) {
            function init(element) {
                $(element).hasClass("wf-tooltip-cancel-ondrag") && !function(element) {
                    $(element).on("mousedown", function() {
                        $(this).addClass("nohover"), end(), $(this).data("title", $(this).attr("title")).attr("title", "");
                    }).on("mouseup", function() {
                        $(this).removeClass("nohover"), $(this).attr("title", $(this).data("title"));
                    });
                }(element), $(element).on("click", function(e) {
                    if (e.preventDefault(), !("click" == options.trigger && $(this).is(options.disabled) || "A" == this.nodeName || $("a", this).length || $(this).hasClass("wf-tooltip-cancel-ondrag"))) {
                        if ("click" == options.trigger) {
                            if ($(".uk-tooltip").is(":visible")) return end();
                            start(e, element);
                        }
                        $(".uk-tooltip").hasClass("uk-tooltip-sticky") ? unpin() : function(element) {
                            $(".uk-tooltip").addClass("uk-tooltip-sticky"), $(".uk-icon-close", ".uk-tooltip").show(), 
                            $(window).on("click.tooltip-blur", function(e) {
                                var el = $(element).get(0), e = e.target;
                                e == el || "LABEL" == el.nodeName && $(el).attr("for") && e == $("#" + $(el).attr("for")).get(0) || e == $(".uk-tooltip").get(0) || 0 === $(e).parents(".uk-tooltip").length && end();
                            });
                        }(element);
                    }
                }), $(element).on("tooltip:close", function() {
                    return end(element);
                }), "hover" == options.trigger && $(element).on("mouseover", function(e) {
                    if (!$(".uk-tooltip").hasClass("uk-tooltip-sticky") && !$(this).hasClass("uk-tooltip-nohover")) return start(e, element);
                }).on("mouseout", function(e) {
                    if (!$(".uk-tooltip").hasClass("uk-tooltip-sticky") && !$(this).hasClass("uk-tooltip-nohover")) return end(element);
                });
            }
            function createTips() {
                var $tips = $(".uk-tooltip");
                $tips.get(0) || ($tips = $('<div class="uk-tooltip" role="tooltip" aria-hidden="true"><span class="close uk-icon uk-icon-close" title="Close"></span><div class="uk-tooltip-inner"></div><div class="arrow"></div></div>').appendTo(options.parent), 
                $(".uk-icon-close", $tips).on("click", function() {
                    end();
                }).hide()), $tips.addClass(options.className), $tips.hasClass("popover") && $tips.find(".arrow").addClass("popover-arrow");
            }
            function start(e, element) {
                createTips();
                var h, parts, title, text, $tips = $(".uk-tooltip");
                $(element).hasClass("hasPopover") && $tips.addClass("popover"), 
                $tips.data("source", element), options.content ? h = options.content : (h = "", 
                text = $(element).attr("title") || "", title = "", text = $(element).data("content") || text, 
                /::/.test(text) && (parts = text.split("::"), title = $.trim(parts[0]), 
                text = $.trim(parts[1])), (title = title || $(element).text()) && (h += "<h4>" + title + "</h4>"), 
                $(element).data("title", $(element).attr("title")).attr("title", ""), 
                $(element).attr("aria-describedby", "uk-tooltip"), h += '<div class="uk-tooltip-content">' + text + "</div>"), 
                $(".uk-tooltip-inner", $tips).html(h), $(element).hasClass("hasPopover") && ($(".uk-tooltip-inner > h4", $tips).addClass("popover-title popover-header"), 
                $(".uk-tooltip-inner > .uk-tooltip-content", $tips).addClass("popover-content popover-body")), 
                $tips.show().addClass("in").attr("aria-hidden", "false"), function(e) {
                    createTips();
                    var $tips = $(".uk-tooltip"), o = options.offsets, pos = $(e.target).offset(), parent = $tips.parent().position(), parent = (pos.left = pos.left - parent.left, 
                    pos.top = pos.top - parent.top, {
                        width: $tips.outerWidth(),
                        height: $tips.outerHeight()
                    }), e = (pos = $.extend(pos, {
                        width: $(e.target).outerWidth(),
                        height: $(e.target).outerHeight()
                    }), options.position), scrollTop = $(document).scrollTop();
                    e = pos.top - parent.height < 0 || pos.top < scrollTop + parent.height + o.y ? e.replace(/(top|center)\s+/, "bottom ") : e.replace(/(bottom|center)\s+/, "top ");
                    e = pos.left + parent.width > $(window).width() ? e.replace("right", "left") : e.replace("left", "right");
                    scrollTop = {
                        "top center": {
                            top: Math.max(pos.top - parent.height - o.y, 10),
                            left: Math.max(pos.left + pos.width / 2 - parent.width / 2, 5)
                        },
                        "bottom center": {
                            top: Math.max(pos.top + pos.height + o.y, 10),
                            left: Math.max(pos.left + pos.width / 2 - parent.width / 2, 5)
                        },
                        "center right": {
                            top: Math.max(pos.top - parent.height / 2 + pos.height / 2, 5),
                            left: Math.max(pos.left + pos.width, 10)
                        },
                        "center left": {
                            top: Math.max(pos.top - parent.height / 2 + pos.height / 2, 5),
                            left: Math.max(pos.left - parent.width, 10)
                        },
                        "bottom right": {
                            top: Math.max(pos.top - parent.height + o.y, 5),
                            left: Math.max(pos.left + pos.width, 10)
                        },
                        "bottom left": {
                            top: Math.max(pos.top - parent.height + pos.height + o.y, 5),
                            left: Math.max(pos.left - parent.width, 10)
                        },
                        "top right": {
                            top: Math.max(pos.top - parent.height - o.y, 10),
                            left: Math.max(pos.left + pos.width, 10)
                        },
                        "top left": {
                            top: Math.max(pos.top - parent.height - o.y, 10),
                            left: Math.max(pos.left - parent.width, 10)
                        }
                    };
                    $.each(e.split(" "), function(i, s) {
                        $tips.addClass(s).addClass("uk-tooltip-" + s), $tips.hasClass("popover") && $tips.addClass(s).addClass("bs-popover-" + s);
                    }), $tips.css(scrollTop[e]);
                }(e), $(element).trigger("tooltip:show"), window.setTimeout(function() {
                    $tips.css("visibility", "visible");
                }, 1);
            }
            function end(element) {
                var $tips = $(".uk-tooltip"), element = $tips.data("source") || element;
                $(element).data("title") && $(element).attr("title", $(element).data("title")), 
                $(element).removeAttr("aria-describedby"), $tips.css("visibility", "hidden").attr("aria-hidden", "true").hide(), 
                $(".uk-tooltip").attr("class", "uk-tooltip").removeClass("in"), 
                $(".uk-tooltip-inner").empty(), $(element).trigger("tooltip:hide"), 
                unpin();
            }
            function unpin() {
                $(".uk-tooltip").removeClass("uk-tooltip-sticky"), $(".uk-icon-close", ".uk-tooltip").hide(), 
                $(window).off("click.tooltip-blur");
            }
            return options = $.extend({
                speed: 150,
                position: "top center",
                className: "",
                offsets: {
                    x: 16,
                    y: 16
                },
                width: 200,
                fixed: !0,
                parent: "body",
                trigger: "hover",
                disabled: ":disabled, .disabled"
            }, options), this.each(function() {
                init(this);
            });
        };
    }(jQuery), function($) {
        $.fn.or = function(fallbackSelector) {
            return this.length ? this : $(fallbackSelector || "body");
        }, $.fn.borderWidget = function() {
            return $(this).on("click change", function() {
                var state = this.checked;
                $(this).parents(".uk-form-controls").find(":input").not(this).toggleClass("uk-text-muted", !state).attr("disabled", function() {
                    return !state || null;
                }), $(this).trigger("border:change");
            }).trigger("change"), this;
        }, $.fn.checkbox = function() {
            return this.each(function() {
                var self = this;
                if ($(this).hasClass("uk-form-constrain")) return this;
                $(this).wrap('<i class="uk-checkbox" />').on("click", function() {
                    $(this).parent().toggleClass("uk-icon-check", this.checked);
                }).on("checkbox:check", function() {
                    $(this).parent().toggleClass("uk-icon-check", self.checked);
                }).parent().toggleClass("uk-icon-check", self.checked).css("margin-top", $(self).parent().height() / 2);
            });
        }, $.fn.equalize = function() {
            return this.each(function() {
                var x = 0, cb = this, $elms = $(this).parents(".uk-form-equalize").find('input[type="text"]'), self = this;
                $(self).on("click", function() {
                    var state = this.checked;
                    $elms.slice(1).prop("disabled", state).prev("label").toggleClass("uk-text-muted", state), 
                    state && (state = $elms.first().val(), $elms.slice(1).val(state).trigger("change"), 
                    $(cb).trigger("equalize:change", [ $elms.addBack() ]));
                }), $elms.first().on("change", function() {
                    $(self).prop("checked") && $elms.not(this).val(this.value).trigger("change"), 
                    $(cb).trigger("equalize:change", [ $elms.addBack() ]);
                }), $(this).on("equalize:update", function() {
                    var value = $elms.first().val(), state = ($elms.each(function() {
                        $(this).val() === value && x++;
                    }), x === $elms.length);
                    $elms.slice(1).prop("disabled", state).prev("label").toggleClass("uk-text-muted", state), 
                    $(this).prop("checked", state);
                });
            });
        }, $.fn.constrain = function() {
            return this.each(function() {
                var $elms = $(this).parents(".uk-form-constrain").find('input[type="text"], input[type="number"]');
                $(this).parent("label").addClass("uk-constrain-label"), $(this).on("constrain:update", function() {
                    $(this).parents(".uk-form-constrain").find('input[type="text"], input[type="number"]').each(function() {
                        $(this).data("tmp", this.value);
                    });
                }), $(this).parents(".uk-form-constrain").toggleClass("uk-constrain-active", this.checked), 
                $(this).on("click", function() {
                    $(this).parents(".uk-form-constrain").toggleClass("uk-constrain-active", this.checked);
                }), $(this).parent().append('<i class="uk-icon-lock" role="presentation"></i><i class="uk-icon-unlocked" role="presentation"></i>'), 
                $elms.each(function() {
                    $(this).data("tmp", this.value);
                }).on("change", function(e) {
                    e.stopPropagation();
                    var e = this, $elms = $(this).parents(".uk-form-constrain").find("input"), b = $elms.not(":checkbox").not(this), cb = $elms.filter(":checkbox"), w = $(e).val(), h = $(b).val(), tw = $(e).data("tmp");
                    if (w && h && tw) {
                        if (-1 !== w.indexOf("%") || -1 !== h.indexOf("%")) return;
                        $(cb).is(":checked") && (h = (h / tw * w).toFixed(0), $(b).val(h).data("tmp", h));
                    }
                    $(e).data("tmp", w), $(cb).trigger("constrain:change", [ $elms ]);
                });
            });
        }, $.fn.repeatable = function() {
            return this.each(function() {
                var self = this;
                if ($(this).data("uk-repeatable")) return this;
                function clone() {
                    var el = $(self).clone(!0, !0);
                    $(el).find("input").val(""), $(self).trigger("repeatable:create", [ self, $(el).get(0) ]), 
                    $(el).insertAfter($(self).siblings(".uk-repeatable").add(self).last());
                }
                $(this).data("uk-repeatable", 1), $(".uk-repeatable-create", this).on("click", function(e) {
                    clone(), e.preventDefault();
                }), $(".uk-repeatable-delete", this).on("click", function(e) {
                    var $elm = $(this).parent().parent();
                    $elm.hide(), $(self).trigger("repeatable:delete", [ self, $elm.get(0) ]), 
                    e.preventDefault();
                }), $(self).on("repeatable:clone", function(e, count) {
                    for (var i = 0; i < count; i++) clone();
                });
            });
        }, $.fn.button = function(options, key, value) {
            options = options || {};
            var map = {
                "uk-icon-circle-arrow-w": "uk-icon-refresh",
                "uk-icon-arrowreturnthick-1-w": "uk-icon-undo",
                "uk-icon-circle-check": "uk-icon-check",
                "uk-icon-check": "uk-icon-check",
                "uk-icon-closethick": "uk-icon-close"
            };
            return this.each(function() {
                if ("string" == typeof options) return "option" === options && key && value && "label" === key && $(".uk-button-text", this).text(value), 
                "enable" === options && $(this).prop("disabled", !1), "disable" === options && $(this).prop("disabled", !0), 
                this;
                var icon;
                $(this).addClass("uk-button").addClass(options.classes || ""), $(this).html('<span class="uk-button-text">' + $(this).text() + "</span>"), 
                options.icons && options.icons.primary && (icon = map[options.icons.primary] || options.icons.primary || "", 
                $('<i class="uk-margin-small-right uk-icon ' + icon + '"></i>').prependTo(this));
            });
        }, $.fn.tabs = function(options, key, value) {
            return this.each(function() {
                var el = this;
                return "string" == typeof options || $(this).data("tabs") ? this : ($(this).addClass("uk-tabs"), 
                $(this).children("ul").addClass("uk-tab"), 0 === $(this).children(".uk-switcher").length && $('<div class="uk-switcher"></div>').append($(this).children("div")).appendTo(this), 
                $(this).children(".uk-switcher").addClass("uk-tabs-panel").children().first().addClass("uk-active").attr("aria-hidden", !1), 
                $(".uk-tab li", el).on("click", function(e) {
                    e.preventDefault(), $(this).find("[autofocus]").trigger("focus"), 
                    $(el).children(".uk-switcher").children().addClass("uk-tabs-hide");
                    var panel = $(el).children(".uk-switcher").children(".uk-active").get(0), tab = $(el).children(".uk-tab").children(".uk-active").get(0), panel = ($(el).trigger("tabs.beforeactivate", [ tab, panel ]), 
                    $(el).children(".uk-tab").children().removeClass("uk-active").attr("aria-selected", !1), 
                    $(el).children(".uk-switcher").children().removeClass("uk-active").attr("aria-hidden", !0), 
                    $(this).addClass("uk-active").attr("aria-selected", !0), $(el).children(".uk-switcher").children().eq($(this).index()).addClass("uk-active").removeClass("uk-tabs-hide").attr("aria-hidden", !1).get(0));
                    $(el).trigger("tabs.activate", [ this, panel ]), e.preventDefault();
                }).first().addClass("uk-active").attr("aria-selected", !0).find("button").trigger("focus"), 
                $("body").on("keydown.tabs", function(e) {
                    var $tabItems, endIndex, parent;
                    $(e.target).hasClass("uk-button-tab") && 37 <= e.keyCode && e.keyCode <= 40 && (parent = e.target.parentNode, 
                    $tabItems = $(parent).siblings().addBack(), endIndex = Math.max(0, $tabItems.length - 1), 
                    parent = $tabItems.index(parent), 37 !== e.keyCode && 38 !== e.keyCode || parent--, 
                    39 !== e.keyCode && 40 !== e.keyCode || parent++, $tabItems.eq(parent = (parent = endIndex < parent ? 0 : parent) < 0 ? endIndex : parent).trigger("click"), 
                    e.preventDefault());
                }), void $(this).data("tabs", !0));
            });
        }, $.fn.accordion = function(options, key, value) {
            var el = this;
            return "string" == typeof options ? "activate" === options && void 0 !== key && $(".uk-accordion-title", this).trigger("click") : ($(this).children("h3").addClass("uk-accordion-title").next("div").addClass("uk-accordion-content").css({
                height: 0,
                position: "relative",
                overflow: "hidden"
            }), $(".uk-accordion-title", this).on("click", function(e) {
                e.preventDefault();
                var tab = this;
                $(".uk-accordion-content", el).height(0), $(".uk-accordion-title", el).removeClass("uk-active"), 
                $(this).addClass("uk-active").next("div").css("height", function(i, v) {
                    return 0 === parseInt(v, 10) ? ($(el).trigger("accordion.activate", [ tab, this ]), 
                    "auto") : 0;
                });
            }), $.isPlainObject(options) && "function" == typeof options.beforeActivate && $(this).on("accordion:activate", function(e, tab) {
                options.beforeActivate(e, {
                    newHeader: tab
                });
            }), $(this).on("accordion:reset", function(e) {
                $(".uk-accordion-content", el).height(0), $(".uk-accordion-title", el).removeClass("uk-active");
            })), this;
        }, $.fn.clearable = function() {
            return this.each(function() {
                var el = this;
                $(this).addClass("uk-form-icon uk-form-icon-flip"), $('<button class="uk-icon uk-icon-close uk-button uk-button-link">').on("click", function() {
                    $(el).find("input").val("").trigger("change");
                }).appendTo(this);
            });
        }, $.fn.dialog = function() {
            return this;
        };
    }(jQuery), function($) {
        var specialKeyCodeMap = {
            9: "tab",
            17: "ctrl",
            18: "alt",
            27: "esc",
            32: "space",
            37: "left",
            39: "right",
            13: "enter",
            91: "cmd",
            38: "up",
            40: "down"
        };
        $.fn.datalist = function(settings) {
            return settings = $.extend({
                seperator: " ",
                loading: "Loading..."
            }, settings), this.each(function() {
                var select = this, options = [], multiple = $(this).prop("multiple"), id = $(this).attr("id");
                if ("INPUT" === this.nodeName && !this.list) return !1;
                $(this).wrap('<div class="uk-datalist-control" role="combobox" aria-autocomplete="list" aria-haspopup="true" aria-expanded="false" aria-owns="' + id + '_datalist_menu" data-label-loading="' + settings.loading + '"></div>');
                var container = $(this).parent(), input = ($(container).attr("aria-multiselectable", multiple), 
                $(this).hide().attr("aria-hidden", "true").attr("tabindex", "-1"), 
                $('<input type="text" autocomplete="off" autocapitalize="off" spellcheck="false" placeholder="..." />')), btn = $('<button type="button" class="uk-button uk-datalist-button" tabindex="-1"></button'), combobox = $('<div class="uk-datalist-combobox"></div>').appendTo(container).append([ input, btn ]), menu = ("SELECT" === this.nodeName && ($(combobox).addClass("uk-datalist-placeholder"), 
                $(input).prop("readonly", !0).attr("placeholder", "")), $('<div id="' + id + '_datalist_menu" class="uk-dropdown uk-dropdown-scrollable uk-datalist-dropdown" role="listbox" aria-multiselectable="' + !!multiple + '"><ul class="uk-nav uk-nav-dropdown"></ul></div>').appendTo(select.parentNode));
                function removeTag(tag) {
                    var values = (values = "string" == typeof (values = $(select).val()) ? values.split(settings.seperator) : values).filter(function(value) {
                        if (value !== $(tag).val()) return !0;
                    });
                    $(select).val(function() {
                        return "INPUT" === this.nodeName ? values.join(settings.seperator) : values;
                    }), $(select).trigger("change", {
                        internal: !0
                    }), $(tag).remove();
                }
                function updateComboBox(data) {
                    var found;
                    settings.input || data.text || $("option", select).each(function() {
                        this.value === data.value && (data.text = $(this).attr("label") || $(this).text());
                    }), $(input).val($.trim(data.text || data.value)).trigger("datalist-input:clear"), 
                    multiple && ($(input).val(""), found = !1, $("button", container).each(function() {
                        this.value === data.value && (found = !0);
                    }), found || $('<button class="uk-button uk-datalist-tag" role="presentation" aria-label="" value="' + data.value + '"><label>' + data.value + "</label></button>").on("click", function(e) {
                        e.preventDefault(), "LABEL" !== e.target.nodeName && removeTag(this);
                    }).insertBefore(combobox));
                }
                function selectItem(data) {
                    var values = $(select).val(), value = ("string" == typeof values && (values = values.split(settings.seperator)), 
                    Array.isArray(values) || (values = [ values ]), data.value || "");
                    if (multiple && -1 < $.inArray(value, values)) $(input).val("").trigger("focus"); else {
                        updateComboBox(data), multiple ? values.push(value) : values = [ value ], 
                        $(select).val(function() {
                            return "INPUT" === this.nodeName ? values.join(settings.seperator) : values;
                        });
                        for (var i = values.length; i--; ) {
                            var val = values[i];
                            $.each(options, function(x, opt) {
                                opt.value === val && values.splice(i, 1);
                            });
                        }
                        var list = select.list || select;
                        $.each(values, function(i, val) {
                            $(list).append(new Option(val, val, !1, !0));
                        }), $(select).trigger("change", {
                            internal: !0
                        });
                    }
                }
                function selectMenuItem(e) {
                    e.preventDefault();
                    e = e.target;
                    "LI" === (e = "A" === e.nodeName ? e.parentNode : e).nodeName && (selectItem({
                        text: e.title,
                        value: e.getAttribute("data-value")
                    }), hideMenu());
                }
                $(select).on("update:option", function(e, option) {
                    var $item = "optgroup" === option.type ? $('<li class="uk-nav-header" tabindex="-1">' + option.text + "</li>") : $('<li title="' + option.text + '" data-value="' + option.value + '" role="option"><a href="#" role="presentation">' + option.text + "</a></li>");
                    $.each([ "style", "class" ], function(i, attr) {
                        option[attr] && $item.attr(attr, option[attr]);
                    }), $("ul", menu).append($item), option.selected && updateComboBox(option);
                }).on("change.datalist", function(e, o) {
                    o && o.internal || $(this).trigger("datalist:update", {
                        change: !0
                    });
                }), $(menu).on("mousedown click touchstart", function(e) {
                    selectMenuItem(e);
                });
                var $items, focusIdx = -1;
                function hideMenu(e) {
                    isMenuOpen() && ($(menu).attr("aria-hidden", "true").parent().removeClass("uk-open"), 
                    focusIdx = -1, $([ container, menu ]).attr("aria-expanded", "false"), 
                    e) && $(input).trigger("focus");
                }
                function positionMenu() {
                    var ch = $(container).outerHeight(), pos = $(container).offset(), ch = pos.top + ch + 2;
                    menu.css({
                        top: ch,
                        left: pos.left,
                        width: $(container).outerWidth(),
                        maxHeight: settings.maxHeight || 160
                    }), $(menu).height() + ch > $(window).height() && $(menu).css("top", pos.top - $(menu).outerHeight() - 2);
                }
                function showMenu() {
                    menu.attr("aria-hidden", "false").parent().addClass("uk-open"), 
                    positionMenu(), $([ container, menu ]).attr("aria-expanded", "true"), 
                    $items = $("li", menu);
                    var values = $(select).val();
                    Array.isArray(values) || (values = [ values ]), $items.each(function() {
                        var val = this.getAttribute("data-value");
                        $(this).toggleClass("uk-active", -1 !== $.inArray(val, values));
                    });
                }
                function isMenuOpen() {
                    return $(menu).parent().hasClass("uk-open");
                }
                function moveFocus(dir) {
                    focusIdx += dir;
                    dir = $items.filter(":visible").filter(function() {
                        return -1 < this.getAttribute("tabindex");
                    });
                    focusIdx < 0 ? $(input).trigger("focus") : focusIdx >= dir.length || ($items.trigger("blur"), 
                    dir.eq(focusIdx).attr("tabindex", 0).trigger("focus"));
                }
                $(input).on("keydown", function(e) {
                    switch (e.keyCode) {
                      case 13:
                        e.preventDefault(), e.stopImmediatePropagation(), "" === this.value ? (showMenu(), 
                        moveFocus(1)) : (selectItem({
                            value: this.value,
                            text: ""
                        }), hideMenu(e));
                        break;

                      case 40:
                        e.preventDefault(), e.stopImmediatePropagation(), showMenu(), 
                        moveFocus(1);
                        break;

                      case 8:
                        var $tags, val;
                        this.value || ($tags = $(".uk-datalist-tag", container)).length && (val = $tags.last().val(), 
                        removeTag($tags.last()), e.preventDefault(), $(this).val(val).trigger("focus"));
                    }
                }), $(input).on("keyup paste", function(e) {
                    var matcher;
                    multiple && e.originalEvent.key === settings.seperator && (selectItem({
                        value: $.trim(this.value),
                        text: ""
                    }), hideMenu(e)), specialKeyCodeMap[e.keyCode] ? (e.preventDefault(), 
                    e.stopPropagation()) : (this.value.length ? showMenu() : hideMenu(e), 
                    matcher = new RegExp("^" + this.value.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&"), "i"), 
                    $("li", menu).each(function() {
                        $(this).toggle(matcher.test($(this).data("value")));
                    }));
                }).on("change", function(e) {
                    "" === this.value ? $(select).val("") : (multiple || selectItem({
                        text: this.value,
                        value: this.value,
                        selected: !0
                    }), e.stopPropagation());
                }).on("focus", function() {
                    $(container).addClass("uk-focus");
                }).on("blur", function(e) {
                    $(container).removeClass("uk-focus");
                }).on("datalist-input:clear", function() {
                    $("li", menu).show();
                }), $(menu).on("keydown", function(e) {
                    isMenuOpen() && (13 === e.keyCode && (selectMenuItem(e), hideMenu(e), 
                    e.preventDefault(), e.stopPropagation()), 27 === e.keyCode ? (hideMenu(e), 
                    e.preventDefault(), e.stopPropagation()) : 36 === e.keyCode ? ($(input).trigger("focus"), 
                    e.preventDefault()) : 38 !== e.keyCode && 40 !== e.keyCode || (moveFocus(e.keyCode - 39), 
                    e.preventDefault()));
                }), $(btn).on("click", function(e) {
                    e.preventDefault(), showMenu(), moveFocus(1);
                }), $("body").on("mousedown touchstart keyup", function(e) {
                    e.keyCode && 9 !== e.keyCode || (e = e.target) == btn.get(0) || e == menu.get(0) || menu.find(e).length || $(e).parents(menu).length || (hideMenu(), 
                    select.list && !container.find(e).length && "" !== (e = input.val()) && selectItem({
                        text: e,
                        value: e,
                        select: !0
                    }));
                }), $(select).on("datalist:update", function(e, o) {
                    var list = select.list || select, o = ((o = o || {}).change || $("option, optgroup", list).each(function() {
                        var text = $(this).attr("label") || $(this).text(), text = ("OPTGROUP" === this.parentNode.nodeName && $(this).addClass("uk-nav-indent"), 
                        {
                            value: this.value,
                            text: text,
                            style: $(this).attr("style") || "",
                            selected: this.selected,
                            title: this.title || "",
                            class: $(this).attr("class") || "",
                            type: this.nodeName.toLowerCase()
                        });
                        $(select).trigger("update:option", text);
                    }), $(this).val());
                    o && ("string" == typeof o && (o = o.split(settings.seperator)), 
                    $.each(o, function(i, value) {
                        updateComboBox({
                            value: value
                        });
                    })), $(this).trigger("datalist:disabled", this.disabled);
                }).on("datalist:disabled", function(e, state) {
                    $([ input, btn ]).each(function() {
                        state ? $(this).prop("disabled", !0) : $(this).prop("disabled", !1).removeAttr("disabled");
                    });
                }).on("datalist:position", function() {
                    positionMenu();
                }).on("datalist:loading", function() {
                    $(container).hasClass("uk-datalist-loading") ? ($(container).removeClass("uk-datalist-loading"), 
                    $(this).trigger("datalist:disabled", !1)) : ($(container).addClass("uk-datalist-loading"), 
                    $(this).trigger("datalist:disabled", !0));
                }).on("datalist:clear", function() {
                    $(input).val(), $("ul", menu).empty();
                }).trigger("datalist:disabled", select.disabled);
            });
        };
    }(jQuery), function($) {
        function ColorPicker(element, options) {
            this.options = $.extend(this.options, options), this.element = element, 
            this._init();
        }
        ColorPicker.prototype = {
            options: {
                color: "#FFFFFF",
                detail: 50,
                speed: 200,
                stylesheets: [],
                custom_colors: "",
                forcedHighContrastMode: !1,
                labels: {
                    picker: "Picker",
                    title: "Color Picker",
                    palette: "Web Colors",
                    named: "Named Colors",
                    template: "Template Colors",
                    custom: "Custom Colors",
                    color: "Color",
                    apply: "Apply",
                    name: "Name"
                },
                dialog: !1,
                parent: "body"
            },
            _strhex: "0123456789abcdef",
            _colors: [ "#000000", "#000033", "#000066", "#000099", "#0000cc", "#0000ff", "#330000", "#330033", "#330066", "#330099", "#3300cc", "#3300ff", "#660000", "#660033", "#660066", "#660099", "#6600cc", "#6600ff", "#990000", "#990033", "#990066", "#990099", "#9900cc", "#9900ff", "#cc0000", "#cc0033", "#cc0066", "#cc0099", "#cc00cc", "#cc00ff", "#ff0000", "#ff0033", "#ff0066", "#ff0099", "#ff00cc", "#ff00ff", "#003300", "#003333", "#003366", "#003399", "#0033cc", "#0033ff", "#333300", "#333333", "#333366", "#333399", "#3333cc", "#3333ff", "#663300", "#663333", "#663366", "#663399", "#6633cc", "#6633ff", "#993300", "#993333", "#993366", "#993399", "#9933cc", "#9933ff", "#cc3300", "#cc3333", "#cc3366", "#cc3399", "#cc33cc", "#cc33ff", "#ff3300", "#ff3333", "#ff3366", "#ff3399", "#ff33cc", "#ff33ff", "#006600", "#006633", "#006666", "#006699", "#0066cc", "#0066ff", "#336600", "#336633", "#336666", "#336699", "#3366cc", "#3366ff", "#666600", "#666633", "#666666", "#666699", "#6666cc", "#6666ff", "#996600", "#996633", "#996666", "#996699", "#9966cc", "#9966ff", "#cc6600", "#cc6633", "#cc6666", "#cc6699", "#cc66cc", "#cc66ff", "#ff6600", "#ff6633", "#ff6666", "#ff6699", "#ff66cc", "#ff66ff", "#009900", "#009933", "#009966", "#009999", "#0099cc", "#0099ff", "#339900", "#339933", "#339966", "#339999", "#3399cc", "#3399ff", "#669900", "#669933", "#669966", "#669999", "#6699cc", "#6699ff", "#999900", "#999933", "#999966", "#999999", "#9999cc", "#9999ff", "#cc9900", "#cc9933", "#cc9966", "#cc9999", "#cc99cc", "#cc99ff", "#ff9900", "#ff9933", "#ff9966", "#ff9999", "#ff99cc", "#ff99ff", "#00cc00", "#00cc33", "#00cc66", "#00cc99", "#00cccc", "#00ccff", "#33cc00", "#33cc33", "#33cc66", "#33cc99", "#33cccc", "#33ccff", "#66cc00", "#66cc33", "#66cc66", "#66cc99", "#66cccc", "#66ccff", "#99cc00", "#99cc33", "#99cc66", "#99cc99", "#99cccc", "#99ccff", "#cccc00", "#cccc33", "#cccc66", "#cccc99", "#cccccc", "#ccccff", "#ffcc00", "#ffcc33", "#ffcc66", "#ffcc99", "#ffcccc", "#ffccff", "#00ff00", "#00ff33", "#00ff66", "#00ff99", "#00ffcc", "#00ffff", "#33ff00", "#33ff33", "#33ff66", "#33ff99", "#33ffcc", "#33ffff", "#66ff00", "#66ff33", "#66ff66", "#66ff99", "#66ffcc", "#66ffff", "#99ff00", "#99ff33", "#99ff66", "#99ff99", "#99ffcc", "#99ffff", "#ccff00", "#ccff33", "#ccff66", "#ccff99", "#ccffcc", "#ccffff", "#ffff00", "#ffff33", "#ffff66", "#ffff99", "#ffffcc", "#ffffff" ],
            _named: {
                "#F0F8FF": "AliceBlue",
                "#FAEBD7": "AntiqueWhite",
                "#7FFFD4": "Aquamarine",
                "#F0FFFF": "Azure",
                "#F5F5DC": "Beige",
                "#FFE4C4": "Bisque",
                "#000000": "Black",
                "#FFEBCD": "BlanchedAlmond",
                "#0000FF": "Blue",
                "#8A2BE2": "BlueViolet",
                "#A52A2A": "Brown",
                "#DEB887": "BurlyWood",
                "#5F9EA0": "CadetBlue",
                "#7FFF00": "Chartreuse",
                "#D2691E": "Chocolate",
                "#FF7F50": "Coral",
                "#6495ED": "CornflowerBlue",
                "#FFF8DC": "Cornsilk",
                "#DC143C": "Crimson",
                "#00008B": "DarkBlue",
                "#008B8B": "DarkCyan",
                "#B8860B": "DarkGoldenRod",
                "#A9A9A9": "DarkGray",
                "#006400": "DarkGreen",
                "#BDB76B": "DarkKhaki",
                "#8B008B": "DarkMagenta",
                "#556B2F": "DarkOliveGreen",
                "#FF8C00": "Darkorange",
                "#9932CC": "DarkOrchid",
                "#8B0000": "DarkRed",
                "#E9967A": "DarkSalmon",
                "#8FBC8F": "DarkSeaGreen",
                "#483D8B": "DarkSlateBlue",
                "#2F4F4F": "DarkSlateGrey",
                "#00CED1": "DarkTurquoise",
                "#9400D3": "DarkViolet",
                "#FF1493": "DeepPink",
                "#00BFFF": "DeepSkyBlue",
                "#696969": "DimGrey",
                "#1E90FF": "DodgerBlue",
                "#B22222": "FireBrick",
                "#FFFAF0": "FloralWhite",
                "#228B22": "ForestGreen",
                "#DCDCDC": "Gainsboro",
                "#F8F8FF": "GhostWhite",
                "#FFD700": "Gold",
                "#DAA520": "GoldenRod",
                "#808080": "Grey",
                "#008000": "Green",
                "#ADFF2F": "GreenYellow",
                "#F0FFF0": "HoneyDew",
                "#FF69B4": "HotPink",
                "#CD5C5C": "IndianRed",
                "#4B0082": "Indigo",
                "#FFFFF0": "Ivory",
                "#F0E68C": "Khaki",
                "#E6E6FA": "Lavender",
                "#FFF0F5": "LavenderBlush",
                "#7CFC00": "LawnGreen",
                "#FFFACD": "LemonChiffon",
                "#ADD8E6": "LightBlue",
                "#F08080": "LightCoral",
                "#E0FFFF": "LightCyan",
                "#FAFAD2": "LightGoldenRodYellow",
                "#D3D3D3": "LightGrey",
                "#90EE90": "LightGreen",
                "#FFB6C1": "LightPink",
                "#FFA07A": "LightSalmon",
                "#20B2AA": "LightSeaGreen",
                "#87CEFA": "LightSkyBlue",
                "#778899": "LightSlateGrey",
                "#B0C4DE": "LightSteelBlue",
                "#FFFFE0": "LightYellow",
                "#00FF00": "Lime",
                "#32CD32": "LimeGreen",
                "#FAF0E6": "Linen",
                "#FF00FF": "Magenta",
                "#800000": "Maroon",
                "#66CDAA": "MediumAquaMarine",
                "#0000CD": "MediumBlue",
                "#BA55D3": "MediumOrchid",
                "#9370D8": "MediumPurple",
                "#3CB371": "MediumSeaGreen",
                "#7B68EE": "MediumSlateBlue",
                "#00FA9A": "MediumSpringGreen",
                "#48D1CC": "MediumTurquoise",
                "#C71585": "MediumVioletRed",
                "#191970": "MidnightBlue",
                "#F5FFFA": "MintCream",
                "#FFE4E1": "MistyRose",
                "#FFE4B5": "Moccasin",
                "#FFDEAD": "NavajoWhite",
                "#000080": "Navy",
                "#FDF5E6": "OldLace",
                "#808000": "Olive",
                "#6B8E23": "OliveDrab",
                "#FFA500": "Orange",
                "#FF4500": "OrangeRed",
                "#DA70D6": "Orchid",
                "#EEE8AA": "PaleGoldenRod",
                "#98FB98": "PaleGreen",
                "#AFEEEE": "PaleTurquoise",
                "#D87093": "PaleVioletRed",
                "#FFEFD5": "PapayaWhip",
                "#FFDAB9": "PeachPuff",
                "#CD853F": "Peru",
                "#FFC0CB": "Pink",
                "#DDA0DD": "Plum",
                "#B0E0E6": "PowderBlue",
                "#800080": "Purple",
                "#FF0000": "Red",
                "#BC8F8F": "RosyBrown",
                "#4169E1": "RoyalBlue",
                "#8B4513": "SaddleBrown",
                "#FA8072": "Salmon",
                "#F4A460": "SandyBrown",
                "#2E8B57": "SeaGreen",
                "#FFF5EE": "SeaShell",
                "#A0522D": "Sienna",
                "#C0C0C0": "Silver",
                "#87CEEB": "SkyBlue",
                "#6A5ACD": "SlateBlue",
                "#708090": "SlateGrey",
                "#FFFAFA": "Snow",
                "#00FF7F": "SpringGreen",
                "#4682B4": "SteelBlue",
                "#D2B48C": "Tan",
                "#008080": "Teal",
                "#D8BFD8": "Thistle",
                "#FF6347": "Tomato",
                "#40E0D0": "Turquoise",
                "#EE82EE": "Violet",
                "#F5DEB3": "Wheat",
                "#FFFFFF": "White",
                "#F5F5F5": "WhiteSmoke",
                "#FFFF00": "Yellow",
                "#9ACD32": "YellowGreen"
            },
            _translate: function(s, d) {
                d = this.options.labels[s] || d || "";
                return d = "undefined" != typeof tinyMCEPopup ? tinyMCEPopup.getLang("colorpicker." + s, d) : d;
            },
            _init: function() {
                var color, self = this;
                this._getStylesheetColors(), this.options.dialog ? $("#tab-content .colorpicker_generated").length || (color = $(this.element).val() || "#000000", 
                /\d/.test(color) || (color = this._namedToHex(color)), (color = /rgb/.test(color) ? this._rgbToHex(color) : color) && -1 === color.indexOf("#") && (color = "#" + color), 
                $(this.element).val(color), $("#colorpicker_color").on("change", function() {
                    var v = this.value;
                    "#" === v.substr(0, 1) && (v = v.substring(1)), self._wheel && self._wheel.setColor("#" + v), 
                    this.value = v;
                }).trigger("change"), this._createTabs(), $("#colorpicker_insert").on("click", function(e) {
                    e.preventDefault(), self._insert();
                }), self._wheel && self._wheel.setColor(color)) : (this.options.widget ? this.widget = $(this.options.widget) : (this.widget = $(this.element).parent().find(".colorpicker_widget"), 
                this.widget.length || (this.widget = $('<span class="colorpicker_widget"></span>').insertAfter(this.element))), 
                $(this.widget).css("background-color", $(this.element).val() || "#000000").tips({
                    trigger: "click",
                    position: "center right",
                    content: '<div id="colorpicker" title="Color Picker">' + self._getContent() + "</div>",
                    className: "wf-colorpicker",
                    opacity: 1,
                    parent: this.options.parent
                }).on("tooltip:show", function() {
                    var color = $(self.element).val() || "#000000";
                    "#" !== (color = /rgb/.test(color) ? this._rgbToHex(color) : color).substr(0, 1) && (color = "#" + color), 
                    $("#tab-content .colorpicker_generated").length || ($("#colorpicker_tabs").html(function(i, h) {
                        return h.replace(/\{#(\w+)\}/gi, function(a, b) {
                            return self._translate(b);
                        });
                    }), $("#colorpicker").append('<div class="modal-footer uk-modal-footer"><div id="colorpicker_preview"><div id="colorpicker_preview_text" class="uk-form-icon uk-form-icon-both"><i class="uk-icon-hashtag"></i><input type="text" id="colorpicker_color" size="8" maxlength="8" value="' + color.substring(1) + '" aria-required="true" /><span class="uk-icon-none" id="colorpicker_preview_color" style="background-color: rgb(0, 0, 0);"></span></div></div><button type="button" class="btn btn-primary uk-button uk-button-primary" id="colorpicker_insert"><i class="uk-icon-check"></i>' + self._translate("apply", "Apply") + "</button></div>"), 
                    $("#colorpicker_preview_color").css("background-color", color), 
                    $("#colorpicker_color").on("change", function() {
                        var v = this.value;
                        "#" === v.substr(0, 1) && (v = v.substring(1)), self._wheel && self._wheel.setColor("#" + v), 
                        this.value = v;
                    }).trigger("change"), $("#colorpicker_insert").on("click", function(e) {
                        e.preventDefault(), self._insert();
                    }), self._createTabs(), self._wheel && self._wheel.setColor(color));
                }));
            },
            _getContent: function() {
                var h = "", o = this.options, h = (h = (h += '<div id="colorpicker_tabs" class="uk-tabs">') + '<ul class="nav nav-tabs uk-tab">' + '<li><a href="#colorpicker_picker" aria-controls="colorpicker_picker" class="active">{#picker}</a></li>') + '<li><a href="#colorpicker_web" aria-controls="colorpicker_web">{#palette}</a></li>' + '<li><a href="#colorpicker_named" aria-controls="colorpicker_named">{#named}</a></li>';
                return o.stylesheets.length && (h += '<li><a href="#colorpicker_template" aria-controls="colorpicker_template">{#template}</a></li>'), 
                h = (h = (h += "</ul>") + '<div class="tab-content uk-switcher uk-tabs-panel">' + '<div id="colorpicker_picker" data-type="picker" class="tab-pane"></div>') + '<div id="colorpicker_web" data-type="web" class="tab-pane"></div>' + '<div id="colorpicker_named" data-type="named" class="tab-pane"></div>', 
                o.stylesheets.length && (h += '<div id="colorpicker_template" data-type="template" class="tab-pane"></div>'), 
                h = h + "</div>" + "</div>";
            },
            _createTabs: function() {
                var self = this, $tab = ($("#colorpicker_tabs").on("tabs.activate", function(e, tab, panel) {
                    var type = $(panel).data("type");
                    self["_create" + type].call(self, $(panel)), $("#colorpicker_insert").css("visibility", function() {
                        return "picker" === type ? "visible" : "hidden";
                    });
                }).tabs(), $(".uk-tab > li:visible", "#colorpicker_tabs").first());
                ($tab = $tab.length ? $tab : $(".uk-tab > li", "#colorpicker_tabs").first()).addClass("active uk-active").trigger("click");
            },
            _blur: function(e) {
                if (e) {
                    if (e.target == this.picker || e.target == this.picker.colorpicker) return !1;
                    var matched = !1;
                    $(this.picker.colorpicker).find("*").each(function() {
                        if (this == e.target) return !(matched = !0);
                    }), matched || this.close();
                }
            },
            _close: function() {
                $(this.widget).trigger("tooltip:close"), $(this.element).trigger("colorpicker:close");
            },
            _insert: function() {
                var color = $("#colorpicker_color").val();
                "#" !== color.substr(0, 1) && (color = "#" + color), $(this.element).trigger("colorpicker:insert", color), 
                color && ($(this.element).val(color).removeClass("placeholder").trigger("change"), 
                $(this.widget).css("background-color", color)), this._close();
            },
            _namedToHex: function(value) {
                var color = "";
                return $.each(this._named, function(name, hex) {
                    if (name.toLowerCase() === value.toLowerCase()) return color = hex, 
                    !0;
                }), color;
            },
            _rgbToHex: function(c) {
                var r, g, re = new RegExp("rgb\\s*\\(\\s*([0-9]+).*,\\s*([0-9]+).*,\\s*([0-9]+).*\\)", "gi");
                return c && (3 == (re = c.replace(re, "$1,$2,$3").split(",")).length ? (r = parseInt(re[0]).toString(16), 
                g = parseInt(re[1]).toString(16), re = parseInt(re[2]).toString(16), 
                "#" + (1 == r.length ? "0" + r : r) + (1 == g.length ? "0" + g : g) + (1 == re.length ? "0" + re : re)) : c);
            },
            _hexToRGB: function(c) {
                return -1 != c.indexOf("#") ? (c = c.replace(new RegExp("[^0-9A-F]", "gi"), ""), 
                {
                    r: parseInt(c.substring(0, 2), 16),
                    g: parseInt(c.substring(2, 4), 16),
                    b: parseInt(c.substring(4, 6), 16)
                }) : null;
            },
            _createpicker: function(parent) {
                var self = this;
                $(parent).hasClass("colorpicker_generated") || (self._wheel = $.farbtastic(parent, $("#colorpicker_color").val(), function(color) {
                    self._showColor(color);
                }), $(parent).addClass("colorwheel colorpicker_generated"));
            },
            _createweb: function(parent) {
                var self = this, h = "";
                $(parent).hasClass("colorpicker_generated") || (h += '<div role="listbox" aria-labelledby="colorpicker_web" tabindex="0"><ul>', 
                $.each(this._colors, function(i, v) {
                    h += '<li style="background-color:' + v + '"><span class="colorpicker_webblock" role="option" aria-labelledby="web_colors_' + i + '" title="' + v + '"></span></li>', 
                    self.options.forcedHighContrastMode && (h += '<canvas class="mceColorSwatch" data-color="' + v + '"></canvas>'), 
                    h += '<span class="mceVoiceLabel" id="web_colors_' + i + '">' + v.toUpperCase() + "</span>";
                }), h += "</ul></div>", $(parent).append(h).append('<br style="clear:both;" />').addClass("colorpicker_generated"), 
                $("span.colorpicker_webblock", parent).on("click", function() {
                    self._insert();
                }).on("mouseover", function() {
                    self._showColor($(this).attr("title"));
                }), this._paintCanvas(parent));
            },
            _createnamed: function(parent) {
                var self = this, h = "";
                $(parent).hasClass("colorpicker_generated") || (h += '<div role="listbox" aria-labelledby="colorpicker_named" tabindex="0"><ul>', 
                $.each(this._named, function(k, v) {
                    h += '<li style="background-color:' + k + '"><span class="colorpicker_namedblock" aria-labelledby="named_colors_' + k + '" title="' + self._translate(k.replace(/[^\w]/g, ""), v) + '"></span></li>', 
                    self.options.forcedHighContrastMode && (h += '<canvas class="mceColorSwatch" data-color="' + v + '"></canvas>'), 
                    h += '<span class="mceVoiceLabel" id="named_colors_' + k + '">' + v.toUpperCase() + "</span>";
                }), h += "</ul></div>", $(parent).append(h).append('<br style="clear:both;" />').addClass("colorpicker_generated").append('<div id="colorpicker_colorname">' + this.options.labels.name + "</div>"), 
                $("span.colorpicker_namedblock", parent).on("click", function() {
                    self._insert();
                }).on("mouseover", function() {
                    self._showColor($(this).parent("li").css("background-color"), $(this).attr("title"));
                }), this._paintCanvas(parent));
            },
            _createtemplate: function(parent) {
                var templateColors, self = this, h = "";
                $(parent).hasClass("colorpicker_generated") || (this.template_colors && (templateColors = this.template_colors, 
                "string" == $.type(this.template_colors) && (templateColors = templateColors.split(",")), 
                h += '<div role="listbox" aria-labelledby="colorpicker_template_label" tabindex="0"><ul>', 
                $.each(templateColors, function(i, v) {
                    4 == v.length && (v += v.substr(1)), h += '<li style="background-color:' + v + '"><span class="colorpicker_templateblock" aria-labelledby="template_colors_' + i + '" title="' + v + '"></span></li>', 
                    self.options.forcedHighContrastMode && (h += '<canvas class="mceColorSwatch" data-color="' + v + '"></canvas>'), 
                    h += '<span class="mceVoiceLabel" id="template_colors_' + i + '">' + v.toUpperCase() + "</span>";
                }), h += "</ul></div>", $(parent).append(h)), this.options.custom_colors && (h = "", 
                $(parent).append('<p id="colorpicker_custom_label">' + this.options.labels.custom + "</p>"), 
                templateColors = this.options.custom_colors.split(","), h += '<div role="listbox" aria-labelledby="colorpicker_custom_label" tabindex="0"><ul>', 
                $.each(templateColors, function(i, v) {
                    4 == v.length && (v += v.replace("#", "")), h += '<li style="background-color:' + v + '"><span class="colorpicker_templateblock" aria-labelledby="custom_colors_' + i + '" title="' + v + '"></span></li>', 
                    self.options.forcedHighContrastMode && (h += '<canvas class="mceColorSwatch" data-color="' + v + '"></canvas>'), 
                    h += '<span class="mceVoiceLabel" style="display:none;" id="custom_colors_' + i + '">' + v.toUpperCase() + "</span>", 
                    (i + 1) % 18 == 0 && (h += "</ul><ul>");
                }), h += "</div>", $(parent).append(h), this._paintCanvas(parent)), 
                $(parent).addClass("colorpicker_generated"), $("span.colorpicker_templateblock", parent).on("click", function() {
                    self._insert();
                }).on("mouseover", function() {
                    self._showColor($(this).attr("title"));
                }));
            },
            _showColor: function(color, name) {
                name && $("#colorpicker_colorname").html(this.options.labels.name + ": " + name), 
                color = color.toLowerCase(), /rgb/.test(color) && (color = this._rgbToHex(color)), 
                $("#colorpicker_preview_color").css("background-color", color), 
                $("#colorpicker_color").val(color.replace("#", ""));
            },
            _changeFinalColor: function(color) {
                color = (color = /#/.test(color) ? color : this._rgbToHex(color)).toLowerCase(), 
                $("#colorpicker_preview").css("background-color", color), $("#colorpicker_color").val(color.replace("#", ""));
            },
            _paintCanvas: function(el) {
                $("canvas.mceColorSwatch", el).each(function() {
                    var context, $canvas = $(this).get(0);
                    $canvas.getContext && (context = $canvas.getContext("2d")) && (context.fillStyle = $canvas.getAttribute("data-color"), 
                    context.fillRect(0, 0, 10, 10));
                });
            },
            _sort_colors: function(colors) {
                var sorted = [], s = [];
                return $.each(colors, function(x, color) {
                    6 == (color = color.replace("#", "").toLowerCase()).length && (condensed = "", 
                    $.each(color.split(""), function(i, c) {
                        i % 2 == 0 && (condensed += c);
                    }), color_str = condensed);
                    var condensed, color_str, v = 0;
                    $.each(color_str.split(""), function(i, c) {
                        v += parseInt(c, 16);
                    }), color && (sorted[v + x] = "#" + color);
                }), $.each(sorted, function(i, c) {
                    c && s.push(c);
                }), s;
            },
            _getStylesheetColors: function() {
                var hex, rgb, doc, el, ifr, h, self = this, o = this.options, colors = [], hexRe = /#[0-9a-f]{3,6}/gi, rgbRe = new RegExp("rgb\\s*\\(\\s*([0-9]+).*,\\s*([0-9]+).*,\\s*([0-9]+).*\\)", "gi");
                function addColor(s) {
                    -1 == $.inArray(s, colors) && colors.push(s);
                }
                function processStyleSheets(stylesheets) {
                    try {
                        $.each(stylesheets, function(i, s) {
                            !function parseCSS(s) {
                                s.imports && $.each(s.imports, function(i, r) {
                                    parseCSS(r);
                                }), $.each(s.cssRules || s.rules, function(i, r) {
                                    switch (r.type || 1) {
                                      case 1:
                                        var css = r.cssText || r.style.cssText;
                                        css && (hex = css.match(hexRe), (rgb = css.match(rgbRe)) && addColor(self._rgbToHex(rgb[0])), 
                                        hex) && addColor(hex[0]);
                                        break;

                                      case 3:
                                        -1 == r.href.indexOf("://") && parseCSS(r.styleSheet);
                                    }
                                });
                            }(s);
                        });
                    } catch (ex) {}
                    return colors;
                }
                "string" == $.type(o.stylesheets[0]) ? !document.getElementById("stylsheets_iframe") && (h = '<!DOCTYPE html><html><head><meta charset="utf-8"><meta http-equiv="X-UA-Compatible" content="IE=edge">', 
                $.each(o.stylesheets, function(i, s) {
                    h += '<link href="' + s + '" rel="stylesheet" type="text/css" />';
                }), h += "</head><body></body></html>", ifr = document.createElement("iframe"), 
                $(ifr).attr({
                    src: 'javascript:""',
                    id: "stylsheets_iframe"
                }).hide().appendTo("body").on("load", function(e) {
                    el = e.target, (doc = el.contentWindow.document) && doc.styleSheets && (self.template_colors = processStyleSheets(doc.styleSheets)), 
                    $(ifr).remove();
                }), doc = ifr.contentWindow.document) && (doc.open(), doc.write(h), 
                doc.close()) : this.template_colors = processStyleSheets(o.stylesheets);
            }
        }, $.fn.colorpicker = function(options) {
            return this.each(function() {
                new ColorPicker(this, options);
            });
        };
    }(jQuery), function($) {
        $.fn.farbtastic = function(callback) {
            return $.farbtastic(this, callback), this;
        }, $.farbtastic = function(container, color, callback) {
            return (container = $(container).get(0)).farbtastic || (container.farbtastic = new $._farbtastic(container, color, callback));
        }, $._farbtastic = function(container, color, callback) {
            var fb = this, e = ($(container).html('<div class="farbtastic"><div class="color"></div><div class="wheel"></div><div class="overlay"></div><div class="h-marker marker"></div><div class="sl-marker marker"></div></div>'), 
            $(".farbtastic", container));
            fb.wheel = $(".wheel", container).get(0), fb.radius = 84, fb.square = 100, 
            fb.width = 194, navigator.appVersion.match(/MSIE [0-6]\./) && $("*", e).each(function() {
                var image;
                "none" != this.currentStyle.backgroundImage && (image = this.currentStyle.backgroundImage, 
                image = this.currentStyle.backgroundImage.substring(5, image.length - 2), 
                $(this).css({
                    backgroundImage: "none",
                    filter: "progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true, sizingMethod=crop, src='" + image + "')"
                }));
            }), fb.linkTo = function(callback) {
                return "object" == typeof fb.callback && $(fb.callback).off("keyup", fb.updateValue), 
                fb.color = null, "function" == typeof callback ? fb.callback = callback : "object" != typeof callback && "string" != typeof callback || (fb.callback = $(callback), 
                fb.callback.on("keyup", fb.updateValue), fb.callback.get(0).value && fb.setColor(fb.callback.get(0).value)), 
                this;
            }, fb.updateValue = function(event) {
                this.value && this.value != fb.color && fb.setColor(this.value);
            }, fb.setColor = function(color) {
                var unpack = fb.unpack(color);
                return fb.color != color && unpack && (fb.color = color, fb.rgb = unpack, 
                fb.hsl = fb.RGBToHSL(fb.rgb), fb.updateDisplay()), this;
            }, fb.setHSL = function(hsl) {
                return fb.hsl = hsl, fb.rgb = fb.HSLToRGB(hsl), fb.color = fb.pack(fb.rgb), 
                fb.updateDisplay(), this;
            }, fb.widgetCoords = function(event) {
                var el = event.target || event.srcElement, reference = fb.wheel;
                if (void 0 !== event.offsetX) {
                    for (var pos = {
                        x: event.offsetX,
                        y: event.offsetY
                    }, e = el; e; ) e.mouseX = pos.x, e.mouseY = pos.y, pos.x += e.offsetLeft, 
                    pos.y += e.offsetTop, e = e.offsetParent;
                    for (var e = reference, offset = {
                        x: 0,
                        y: 0
                    }; e; ) {
                        if (void 0 !== e.mouseX) {
                            x = e.mouseX - offset.x, y = e.mouseY - offset.y;
                            break;
                        }
                        offset.x += e.offsetLeft, offset.y += e.offsetTop, e = e.offsetParent;
                    }
                    for (e = el; e; ) e.mouseX = void 0, e.mouseY = void 0, e = e.offsetParent;
                } else var pos = fb.absolutePosition(reference), x = (event.pageX || 0 * (event.clientX + $("html").get(0).scrollLeft)) - pos.x, y = (event.pageY || 0 * (event.clientY + $("html").get(0).scrollTop)) - pos.y;
                return {
                    x: x - fb.width / 2,
                    y: y - fb.width / 2
                };
            }, fb.mousedown = function(event) {
                var pos = fb.widgetCoords(event);
                return fb.circleDrag = 2 * Math.max(Math.abs(pos.x), Math.abs(pos.y)) > fb.square, 
                fb.mousemove(event), !1;
            }, fb.touchconvert = function(e) {
                return e = e.originalEvent.touches.item(0);
            }, fb.touchmove = function(e) {
                return fb.mousemove(fb.touchconvert(e)), event.preventDefault(), 
                !1;
            }, fb.touchend = function(event) {
                return $(document).off("touchmove", fb.touchmove), $(document).off("touchend", fb.touchend), 
                document.dragging = !1, event.preventDefault(), !1;
            }, fb.mousemove = function(event) {
                var hue, event = fb.widgetCoords(event);
                return fb.circleDrag ? ((hue = Math.atan2(event.x, -event.y) / 6.28) < 0 && (hue += 1), 
                fb.setHSL([ hue, fb.hsl[1], fb.hsl[2] ])) : (hue = Math.max(0, Math.min(1, .5 - event.x / fb.square)), 
                event = Math.max(0, Math.min(1, .5 - event.y / fb.square)), fb.setHSL([ fb.hsl[0], hue, event ])), 
                !1;
            }, fb.mouseup = function() {
                $(document).off("mousemove", fb.mousemove), $(document).off("mouseup", fb.mouseup), 
                document.dragging = !1;
            }, fb.updateDisplay = function() {
                var angle = 6.28 * fb.hsl[0];
                $(".h-marker", e).css({
                    left: Math.round(Math.sin(angle) * fb.radius + fb.width / 2) + "px",
                    top: Math.round(-Math.cos(angle) * fb.radius + fb.width / 2) + "px"
                }), $(".sl-marker", e).css({
                    left: Math.round(fb.square * (.5 - fb.hsl[1]) + fb.width / 2) + "px",
                    top: Math.round(fb.square * (.5 - fb.hsl[2]) + fb.width / 2) + "px"
                }), $(".color", e).css("backgroundColor", fb.pack(fb.HSLToRGB([ fb.hsl[0], 1, .5 ]))), 
                "object" == typeof fb.callback ? ($(fb.callback).css({
                    backgroundColor: fb.color,
                    color: .5 < fb.hsl[2] ? "#000" : "#fff"
                }), $(fb.callback).each(function() {
                    this.value && this.value != fb.color && (this.value = fb.color);
                })) : "function" == typeof fb.callback && fb.callback.call(fb, fb.color);
            }, fb.absolutePosition = function(el) {
                var r = {
                    x: el.offsetLeft,
                    y: el.offsetTop
                };
                return el.offsetParent && (el = fb.absolutePosition(el.offsetParent), 
                r.x += el.x, r.y += el.y), r;
            }, fb.pack = function(rgb) {
                var r = Math.round(255 * rgb[0]), g = Math.round(255 * rgb[1]), rgb = Math.round(255 * rgb[2]);
                return "#" + (r < 16 ? "0" : "") + r.toString(16) + (g < 16 ? "0" : "") + g.toString(16) + (rgb < 16 ? "0" : "") + rgb.toString(16);
            }, fb.unpack = function(color) {
                return 7 == color.length ? [ parseInt("0x" + color.substring(1, 3)) / 255, parseInt("0x" + color.substring(3, 5)) / 255, parseInt("0x" + color.substring(5, 7)) / 255 ] : 4 == color.length ? [ parseInt("0x" + color.substring(1, 2)) / 15, parseInt("0x" + color.substring(2, 3)) / 15, parseInt("0x" + color.substring(3, 4)) / 15 ] : void 0;
            }, fb.HSLToRGB = function(hsl) {
                var h = hsl[0], s = hsl[1], hsl = hsl[2], s = hsl <= .5 ? hsl * (s + 1) : hsl + s - hsl * s, hsl = 2 * hsl - s;
                return [ this.hueToRGB(hsl, s, h + .33333), this.hueToRGB(hsl, s, h), this.hueToRGB(hsl, s, h - .33333) ];
            }, fb.hueToRGB = function(m1, m2, h) {
                return 6 * (h = h < 0 ? h + 1 : 1 < h ? h - 1 : h) < 1 ? m1 + (m2 - m1) * h * 6 : 2 * h < 1 ? m2 : 3 * h < 2 ? m1 + (m2 - m1) * (.66666 - h) * 6 : m1;
            }, fb.RGBToHSL = function(rgb) {
                var r = rgb[0], g = rgb[1], rgb = rgb[2], min = Math.min(r, Math.min(g, rgb)), max = Math.max(r, Math.max(g, rgb)), delta = max - min, min = (min + max) / 2, h = 0;
                return 0 < delta && (max == r && max != g && (h += (g - rgb) / delta), 
                max == g && max != rgb && (h += 2 + (rgb - r) / delta), max == rgb && max != r && (h += 4 + (r - g) / delta), 
                h /= 6), [ h, 0 < min && min < 1 ? delta / (min < .5 ? 2 * min : 2 - 2 * min) : 0, min ];
            }, $("*", e).on("mousedown", function(e) {
                document.dragging || ($(document).on("mousemove", fb.mousemove).on("mouseup", fb.mouseup), 
                document.dragging = !0), fb.mousedown(e);
            }), $("*", e).on("touchstart", function(e) {
                return document.dragging || ($(document).on("touchmove", fb.touchmove).on("touchend", fb.touchend), 
                document.dragging = !0), fb.mousedown(fb.touchconvert(e)), e.preventDefault(), 
                !1;
            }), fb.setColor("#000000"), callback && fb.linkTo(callback);
        };
    }(jQuery), function($) {
        var standalone = "undefined" == typeof tinyMCEPopup, Wf = {
            language: "",
            options: {
                selectChange: $.noop,
                site: "",
                root: "",
                help: $.noop,
                alerts: "",
                classes: []
            },
            getURI: function(absolute) {
                return standalone ? absolute ? this.options.root : this.options.site : tinyMCEPopup.editor.documentBaseURI.getURI(absolute);
            },
            init: function(options) {
                var ed, self = this;
                function updateMedia(before, after) {
                    var basedir = $.fn.filebrowser.getbasedir();
                    before = Wf.String.path(basedir, before), after = Wf.String.path(basedir, after), 
                    ed.onUpdateMedia.dispatch(ed, {
                        before: before,
                        after: after
                    });
                }
                $.extend(this.options, options), $(".mceActionPanel, .actionPanel").addClass("uk-modal-footer"), 
                !/MSIE/.test(navigator.userAgent) && -1 === navigator.userAgent.indexOf("Trident/") && -1 === navigator.userAgent.indexOf("Edge/") || $("#jce").addClass("ie"), 
                $("button#insert, input#insert, button#update, input#update").button({
                    icons: {
                        primary: "uk-icon-check"
                    }
                }).addClass("uk-button-primary"), $("button#refresh, input#refresh").button({
                    icons: {
                        primary: "uk-icon-refresh"
                    }
                }), $("#cancel").button({
                    icons: {
                        primary: "uk-icon-cancel"
                    }
                }), standalone || (this.createClassList("classes", this.options.classes), 
                $("#apply").button({
                    icons: {
                        primary: "uk-icon-plus"
                    }
                }), $("#help").button({
                    icons: {
                        primary: "uk-icon-help"
                    }
                }).on("click", function(e) {
                    e.preventDefault(), self.help();
                }), $("#cancel").on("click", function(e) {
                    tinyMCEPopup.close(), e.preventDefault();
                }), $("#tabs").tabs(), this.createColourPickers(), this.createBrowsers(), 
                $(".uk-datalist").datalist({
                    loading: self.translate("message_load", "Loading...")
                }), $(".uk-input-clear").clearable(), $(".hastip, .tip, .tooltip").tips(), 
                $("#align, #clear, #dir").on("change", function() {
                    self.updateStyles();
                }), $('input[id^="margin_"]').on("change", function() {
                    self.updateStyles();
                }), $("#border").borderWidget().on("border:change", function() {
                    self.updateStyles();
                }), $("#border_width, #border_style, #border_color").on("change", function() {
                    self.updateStyles();
                }), $("#style").on("change", function() {
                    self.setStyles();
                }), $(".uk-constrain-checkbox").constrain(), $(".uk-equalize-checkbox").equalize(), 
                "html5-strict" === tinyMCEPopup.editor.settings.schema && tinyMCEPopup.editor.settings.validate && $(".html4").hide().find(":input").prop("disabled", !0), 
                $(".uk-repeatable").repeatable(), $("body").on("keydown.tab", function(e) {
                    var $navItems, endIndex, idx;
                    9 === e.keyCode && ($navItems = $(':input:visible:enabled, span[role="combobox"]', this).not('input[type="file"]').filter(function() {
                        return 0 <= this.getAttribute("tabindex");
                    })).length && ($navItems.attr("tabindex", 0), e.shiftKey && $navItems.reverse(), 
                    endIndex = Math.max(0, $navItems.length - 1), idx = $navItems.index(e.target) + 1, 
                    $navItems.eq(idx = endIndex < idx ? 0 : idx).trigger("focus").attr("tabindex", 1), 
                    e.preventDefault(), e.stopImmediatePropagation());
                }), $(".uk-tabs-panel").on("scroll.tabs", function(e) {
                    $("select").trigger("datalist:position", e);
                }), $("body").on("keydown.backspace", function(e) {
                    8 !== e.keyCode || !e.target || e.target && ("INPUT" === e.target.nodeName || "SELECT" === e.target.nodeName || "TEXTAREA" === e.target.nodeName) || (e.preventDefault(), 
                    e.stopImmediatePropagation());
                }), $("body").on("keyup.esc", function(e) {
                    27 === e.keyCode && (e.preventDefault(), e.stopPropagation(), 
                    $(".uk-modal-close").length ? $(".uk-modal-close").not(":submit").trigger("click") : tinyMCEPopup.close());
                }), standalone) || (ed = tinyMCEPopup.editor).onUpdateMedia && $(window).ready(function() {
                    $("[data-filebrowser]").on("filebrowser:onfilerename filebrowser:onfolderrename", function(e, before, after) {
                        updateMedia(before, after);
                    }).on("filebrowser:onpaste", function(e, type, before, after) {
                        "moveItem" == type && updateMedia(before, after);
                    });
                });
            },
            getName: function() {
                return $("body").data("plugin");
            },
            getPath: function(plugin) {
                return standalone ? this.options.site + "components/com_jce/editor/tiny_mce/plugins/" + this.getName() : tinyMCEPopup.editor.plugins[this.getName()].url;
            },
            loadLanguage: function() {
                var ed, u;
                standalone || (u = (ed = tinyMCEPopup.editor).getParam("document_base_url") + "components/com_jce/editor/tiny_mce") && ed.settings.language && !1 !== ed.settings.language_load && (u += "/langs/" + ed.settings.language + "_dlg.js", 
                tinymce.ScriptLoader.isDone(u) || (document.write('<script type="text/javascript" src="' + tinymce._addVer(u) + '"><\/script>'), 
                tinymce.ScriptLoader.markDone(u)));
            },
            help: function() {
                var ed = tinyMCEPopup.editor;
                ed.windowManager.open({
                    url: ed.getParam("site_url") + "index.php?option=com_jce&task=plugin.display&plugin=help&lang=" + ed.settings.language + "&section=editor&category=" + this.getName(),
                    title: ed.getLang("dlg.help", "Help"),
                    width: 896,
                    height: 768,
                    size: "mce-modal-landscape-full",
                    close_previous: 0
                });
            },
            createClassList: function(id, options) {
                var classes, custom, importcss_classes, seen, ed = tinyMCEPopup.editor, lst = document.getElementById(id), id = [], filter = ed.settings.class_filter, PreviewCss = tinymce.util.PreviewCss;
                lst && (options = (options = "string" == typeof options ? options.split(/[\s,]+/) : options) || [], 
                lst.list && (lst = lst.list), options.length || (classes = [], custom = ed.getParam("styleselect_custom_classes"), 
                importcss_classes = ed.settings.importcss_classes || ed.plugins.importcss && ed.plugins.importcss.get && ed.plugins.importcss.get(), 
                custom && (id = id.concat(custom.split(","))), !1 !== ed.getParam("styleselect_stylesheet") && Array.isArray(importcss_classes) && (importcss_classes.forEach(function(item) {
                    var val = item.class;
                    filter && !filter(val, val) || classes.push(item);
                }), classes.length && (id = id.concat(classes)), seen = {}, id = id.filter(function(item) {
                    item = "string" == typeof item ? item : item.class;
                    return !(!item || seen[item]) && (seen[item] = !0);
                })), id.forEach(function(item) {
                    var opt, className = (item = "string" == typeof item ? {
                        selector: item,
                        class: "",
                        style: ""
                    } : item).class;
                    className && (opt = {
                        title: item.title || className,
                        value: className,
                        style: ""
                    }, (item = item.style || PreviewCss.getCssText(ed, {
                        classes: className
                    })) && (opt.style = ed.dom.serializeStyle(ed.dom.parseStyle(item))), 
                    options.push(opt));
                }), PreviewCss.reset()), options.forEach(function(item) {
                    if ((item = "string" == typeof item ? {
                        title: item,
                        value: item
                    } : item) && item.title && item.value) {
                        for (var elm, found = !1, i = 0; i < lst.options.length; i++) if (lst.options[i].value === item.value) {
                            found = !0;
                            break;
                        }
                        found || (elm = new Option(item.title, item.value), item.style && elm.setAttribute("style", item.style), 
                        lst.appendChild(elm));
                    }
                }));
            },
            createColourPickers: function() {
                var self = this, ed = tinyMCEPopup.editor, doc = ed.getDoc();
                $("input.color, input.colour").each(function() {
                    var html, stylesheets, id = $(this).attr("id"), v = this.value, elm = this, $picker = (v && "#" === v.charAt(0) && (this.value = v.substr(1), 
                    v = this.value), $(this).siblings(":input").length && $(this).wrap("<span />"), 
                    $(this).parent(".uk-form-controls, td, span").addClass("uk-form-icon uk-form-icon-both").prepend('<i class="uk-icon-hashtag" />'), 
                    $('<button class="uk-button-link uk-icon-none uk-icon-colorpicker" title="' + self.translate("colorpicker") + '" aria-label="' + self.translate("colorpicker") + '" id="' + id + '_pick"></button>').insertAfter(this).attr("disabled", function() {
                        return !!$(elm).is(":disabled") || null;
                    })), v = ($(this).on("colorpicker:pick", function() {
                        var v = this.value;
                        "#" !== v.charAt(0) && (v = "#" + v), $(this).next(".uk-icon-colorpicker").css("background-color", v);
                    }), $(this).on("change", function(e) {
                        e.preventDefault(), e.stopPropagation();
                        e = this.value;
                        e && "#" === e.charAt(0) && $(this).val(e.substr(1)), "" === e && (e = "000000"), 
                        $(this).next(".uk-icon-colorpicker").attr("disabled", function() {
                            return !!elm.disabled || null;
                        }), $(this).trigger("colorpicker:pick", "#" + e);
                    }).trigger("change"), ed.getParam("colorpicker_custom_colors", ""));
                    "simple" === ed.getParam("colorpicker_type", "") && v.length ? ("string" == typeof v && (v = v.split(",")), 
                    html = '<div role="listbox" tabindex="0" class="wf-colorpicker-simple-colors">', 
                    $.each(v, function(i, col) {
                        4 == col.length && (col += col.substr(1)), html += '<div style="background-color:' + col + '" data-color="' + col + '" title="' + col + '"><span aria-hidden="true" aria-label="' + col + '"></span></div>';
                    }), html += "</div>", $picker.tips({
                        trigger: "click",
                        position: "bottom center",
                        content: '<div id="colorpicker" aria-label="Colorpicker" title="Color Picker">' + html + "</div>",
                        className: "wf-colorpicker wf-colorpicker-simple",
                        opacity: 1
                    }).on("tooltip:show", function() {
                        $("#colorpicker").on("click", ".wf-colorpicker-simple-colors > div", function(e) {
                            e = $(e.target).data("color");
                            e && ($(elm).val(e).trigger("change"), $picker.trigger("tooltip:close"));
                        });
                    })) : (stylesheets = [], doc.styleSheets.length && $.each(doc.styleSheets, function(i, s) {
                        s.href && -1 == s.href.indexOf("tiny_mce") && stylesheets.push(s);
                    }), id = $.extend(ColorPicker.settings, {
                        widget: $picker,
                        labels: {
                            picker_tab: "Picker",
                            title: "Color Picker",
                            palette_tab: "Palette",
                            palette: "Web Colors",
                            named_tab: "Named",
                            named: "Named Colors",
                            template_tab: "Template",
                            template: "Template Colors",
                            color: "Color",
                            apply: "Apply",
                            name: "Name"
                        },
                        stylesheets: stylesheets,
                        custom_colors: v
                    }), $(this).colorpicker(id));
                });
            },
            createBrowsers: function(el, callback, filter) {
                var self = this;
                el && $(el).addClass("browser").addClass(filter || ""), $("input.browser").add(el).each(function() {
                    var el, input = this;
                    filter = $(el = this).hasClass("image") || $(el).hasClass("images") ? "images" : $(el).hasClass("html") ? "html" : $(el).hasClass("media") ? "media" : "files", 
                    $(this).parent("td, .uk-form-controls").addClass("uk-form-icon uk-form-icon-flip");
                    $('<button class="uk-icon uk-icon-' + {
                        images: "picture",
                        html: "file-text",
                        files: "file-text",
                        media: "film"
                    }[filter] + ' uk-button uk-button-link" title="' + self.translate("browse", "Browse for Files") + '" aria-label="' + self.translate("browse", "Browse for Files") + '"></button>').on("click", function(e) {
                        return e.preventDefault(), tinyMCEPopup.execCommand("mceFileBrowser", !0, {
                            callback: callback || $(input).attr("id"),
                            value: input.value,
                            filter: $(this).attr("data-filter") || filter,
                            caller: self.getName(),
                            window: window
                        });
                    }).insertAfter(this);
                });
            },
            getLanguage: function() {
                var s;
                return this.language || (2 < (s = $("body").attr("lang") || "en").length && (s = s.substr(0, 2)), 
                this.language = s), this.language;
            },
            sizeToFit: function(o, c) {
                var x = c.width, c = c.height, w = o.width, o = o.height;
                return x / w < w / o ? (o *= x / w, w = x, c < o && (w *= c / o, 
                o = c)) : (w *= c / o, o = c, x < w && (o *= x / w, w = x)), {
                    width: Math.round(w),
                    height: Math.round(o)
                };
            },
            translate: function(s, ds) {
                return tinyMCEPopup.getLang("dlg." + s, ds || s);
            },
            Storage: {
                get: function(n, s, fn) {
                    return !window.sessionStorage || void 0 === (n = sessionStorage.getItem(n)) || null == n || fn && "function" == typeof fn && !fn(n) ? s : "null" === n ? null : "true" === n || "false" !== n && n;
                },
                set: function(n, v) {
                    window.sessionStorage && sessionStorage.setItem(n, v);
                }
            }
        };
        Wf.loadLanguage(), window.Wf = Wf, window.TinyMCE_Utils = {
            fillClassList: function(id) {
                Wf.createClassList(id);
            }
        };
    }(jQuery), void 0 === ColorPicker && (ColorPicker = {
        settings: {}
    }), function($, Wf) {
        Wf.URL = $.URL = {
            toAbsolute: function(url) {
                return "undefined" != typeof tinyMCEPopup ? tinyMCEPopup.editor.documentBaseURI.toAbsolute(url) : /http(s)?:\/\//.test(url) ? url : Wf.getURI(!0) + url.substr(0, url.indexOf("/"));
            },
            toRelative: function(url) {
                return "undefined" != typeof tinyMCEPopup ? tinyMCEPopup.editor.documentBaseURI.toRelative(url) : /http(s)?:\/\//.test(url) ? url.substr(url.indexOf("/")) : url;
            }
        };
    }(jQuery, Wf), function($, Wf) {
        var asciiMap = {
            192: "A",
            193: "A",
            194: "A",
            195: "A",
            196: "A",
            197: "A",
            198: "AE",
            199: "C",
            200: "E",
            201: "E",
            202: "E",
            203: "E",
            204: "I",
            205: "I",
            206: "I",
            207: "I",
            208: "D",
            209: "N",
            210: "O",
            211: "O",
            212: "O",
            213: "O",
            214: "O",
            216: "O",
            217: "U",
            218: "U",
            219: "U",
            220: "U",
            221: "Y",
            223: "s",
            224: "a",
            225: "a",
            226: "a",
            227: "a",
            228: "a",
            229: "a",
            230: "ae",
            231: "c",
            232: "e",
            233: "e",
            234: "e",
            235: "e",
            236: "i",
            237: "i",
            238: "i",
            239: "i",
            241: "n",
            242: "o",
            243: "o",
            244: "o",
            245: "o",
            246: "o",
            248: "o",
            249: "u",
            250: "u",
            251: "u",
            252: "u",
            253: "y",
            255: "y",
            256: "A",
            257: "a",
            258: "A",
            259: "a",
            260: "A",
            261: "a",
            262: "C",
            263: "c",
            264: "C",
            265: "c",
            266: "C",
            267: "c",
            268: "C",
            269: "c",
            270: "D",
            271: "d",
            272: "D",
            273: "d",
            274: "E",
            275: "e",
            276: "E",
            277: "e",
            278: "E",
            279: "e",
            280: "E",
            281: "e",
            282: "E",
            283: "e",
            284: "G",
            285: "g",
            286: "G",
            287: "g",
            288: "G",
            289: "g",
            290: "G",
            291: "g",
            292: "H",
            293: "h",
            294: "H",
            295: "h",
            296: "I",
            297: "i",
            298: "I",
            299: "i",
            300: "I",
            301: "i",
            302: "I",
            303: "i",
            304: "I",
            305: "i",
            306: "IJ",
            307: "ij",
            308: "J",
            309: "j",
            310: "K",
            311: "k",
            313: "L",
            314: "l",
            315: "L",
            316: "l",
            317: "L",
            318: "l",
            319: "L",
            320: "l",
            321: "l",
            322: "l",
            323: "N",
            324: "n",
            325: "N",
            326: "n",
            327: "N",
            328: "n",
            329: "n",
            332: "O",
            333: "o",
            334: "O",
            335: "o",
            336: "O",
            337: "o",
            338: "OE",
            339: "oe",
            340: "R",
            341: "r",
            342: "R",
            343: "r",
            344: "R",
            345: "r",
            346: "S",
            347: "s",
            348: "S",
            349: "s",
            350: "S",
            351: "s",
            352: "S",
            353: "s",
            354: "T",
            355: "t",
            356: "T",
            357: "t",
            358: "T",
            359: "t",
            360: "U",
            361: "u",
            362: "U",
            363: "u",
            364: "U",
            365: "u",
            366: "U",
            367: "u",
            368: "U",
            369: "u",
            370: "U",
            371: "u",
            372: "W",
            373: "w",
            374: "Y",
            375: "y",
            376: "Y",
            377: "Z",
            378: "z",
            379: "Z",
            380: "z",
            381: "Z",
            382: "z",
            383: "s",
            402: "f",
            416: "O",
            417: "o",
            431: "U",
            432: "u",
            461: "A",
            462: "a",
            463: "I",
            464: "i",
            465: "O",
            466: "o",
            467: "U",
            468: "u",
            469: "U",
            470: "u",
            471: "U",
            472: "u",
            473: "U",
            474: "u",
            475: "U",
            476: "u",
            506: "A",
            507: "a",
            508: "AE",
            509: "ae",
            510: "O",
            511: "o"
        };
        Wf.String = {
            basename: function(s) {
                return s.replace(/^.*[\/\\]/g, "");
            },
            dirname: function(s) {
                return /[\\\/]+/.test(s) ? s.replace(/\\/g, "/").replace(/\/[^\/]*\/?$/, "") : "";
            },
            filename: function(s) {
                return this.stripExt(this.basename(s));
            },
            getExt: function(s) {
                return s.substring(s.length, s.lastIndexOf(".") + 1);
            },
            stripExt: function(s) {
                return s.replace(/\.[^.]+$/i, "");
            },
            pathinfo: function(s) {
                return {
                    basename: this.basename(s),
                    dirname: this.dirname(s),
                    extension: this.getExt(s),
                    filename: this.filename(s)
                };
            },
            path: function(a, b) {
                return "array" === $.type(a) ? this.clean(a.join("/")) : this.clean(a + "/" + b);
            },
            clean: function(s) {
                var parts;
                return -1 !== s.indexOf("://") ? ((parts = s.split("://"))[1] = parts[1].replace(/\/+/g, "/"), 
                parts.join("://")) : s.replace(/\/+/g, "/");
            },
            toASCII: function(string) {
                return string.replace(/([^\w\.\-\s ])/gi, function(str) {
                    return asciiMap[str.charCodeAt(0)] || "";
                });
            },
            _toUnicode: function(s) {
                for (var c = s.toString(16).toUpperCase(); c.length < 4; ) c = "0" + c;
                return "\\u" + c;
            },
            safe: function(s, mode, spaces, textcase) {
                mode = mode || "utf-8";
                for (var r = "", i = 0, ln = (s = (s = s.replace(/[\s ]+/g, spaces = spaces || "_")).replace(/[\+\\\/\?\#%&<>"\'=\[\]\{\},;@\^\(\)\xa3\u20ac$~]/g, "")).length; i < ln; i++) {
                    var ch = s[i];
                    /[^\w\.\-\s ]/.test(ch) && this._toUnicode(ch.charCodeAt(0)) < "\\u007F" || (r += ch);
                }
                if (s = r, s = (s = (s = (s = "ascii" === mode ? this.toASCII(s) : s).replace(/(\.){2,}/g, "")).replace(/^\./, "")).replace(/\.$/, ""), 
                s = this.basename(s), textcase) switch (textcase) {
                  case "lowercase":
                    s = s.toLowerCase();
                    break;

                  case "uppercase":
                    s = s.toUpperCase();
                }
                return s;
            },
            query: function(s) {
                var p = {};
                return -1 !== (s = this.decode(s)).indexOf("=") && (/\?/.test(s) && (s = s.substring(s.indexOf("?") + 1)), 
                s = (s = /#/.test(s) ? s.substr(0, s.indexOf("#")) : s).replace(/&amp;/g, "&").split("&"), 
                $.each(s, function(i, item) {
                    item && (item = item.split("="), p[item[0]] = item[1]);
                })), p;
            },
            encode: function(s) {
                var baseEntities = {
                    '"': "&quot;",
                    "'": "&#39;",
                    "<": "&lt;",
                    ">": "&gt;",
                    "&": "&amp;"
                };
                return ("" + s).replace(/[<>&\"\']/g, function(chr) {
                    return baseEntities[chr] || chr;
                });
            },
            decode: function(s) {
                var reverseEntities = {
                    "&lt;": "<",
                    "&gt;": ">",
                    "&amp;": "&",
                    "&quot;": '"',
                    "&apos;": "'"
                };
                return s.replace(/&(#)?([\w]+);/g, function(all, numeric, value) {
                    return numeric ? String.fromCharCode(value) : reverseEntities[all];
                });
            },
            escape: function(s) {
                return encodeURI(s);
            },
            unescape: function(s) {
                return decodeURI(s);
            },
            encodeURI: function(s, preserve_urls) {
                return s && 0 === s.indexOf("file://") || (s = encodeURIComponent(decodeURIComponent(s)).replace(/%2F/g, "/"), 
                preserve_urls && (s = s.replace(/%(21|2A|27|28|29|3B|3A|40|26|3D|2B|24|2C|3F|25|23|5B|5D)/g, function(a, b) {
                    return String.fromCharCode(parseInt(b, 16));
                }))), s;
            },
            buildURI: function(s) {
                return -1 !== (s = /^\s*www\./.test(s) ? "http://" + s : s).indexOf("{") ? s : s.replace(/ /g, "%20");
            },
            toHex: function(color) {
                var r, g, re = new RegExp("rgb\\s*\\(\\s*([0-9]+).*,\\s*([0-9]+).*,\\s*([0-9]+).*\\)", "gi"), re = color.replace(re, "$1,$2,$3").split(",");
                return 3 == re.length ? (r = parseInt(re[0], 10).toString(16), g = parseInt(re[1], 10).toString(16), 
                re = parseInt(re[2], 10).toString(16), "#" + (r = 1 == r.length ? 0 + r : r) + (g = 1 == g.length ? 0 + g : g) + (re = 1 == re.length ? 0 + re : re)) : color;
            },
            toRGB: function(color) {
                return -1 != color.indexOf("#") ? (color = color.replace(new RegExp("[^0-9A-F]", "gi"), ""), 
                "rgb(" + parseInt(color.substring(0, 2), 16) + "," + parseInt(color.substring(2, 4), 16) + "," + parseInt(color.substring(4, 6), 16) + ")") : color;
            },
            ucfirst: function(s) {
                return s.charAt(0).toUpperCase() + s.substring(1);
            },
            formatSize: function(s, int) {
                var n;
                return s ? 1048576 < s ? (n = Math.round(s / 1048576 * 100) / 100, 
                int ? n : n + " " + Wf.translate("size_mb", "MB")) : 1024 < s ? (n = Math.round(s / 1024 * 100) / 100, 
                int ? n : n + " " + Wf.translate("size_kb", "KB")) : int ? s : s + " " + Wf.translate("size_bytes", "Bytes") : "";
            },
            formatDate: function(time, fmt) {
                return time ? (time = new Date(1e3 * time), (fmt = (fmt = (fmt = (fmt = (fmt = (fmt = (fmt = (fmt = (fmt = (fmt = (fmt = (fmt = fmt || "%d/%m/%Y, %H:%M").replace("%D", "%m/%d/%y")).replace("%r", "%I:%M:%S %p")).replace("%Y", "" + time.getFullYear())).replace("%y", "" + time.getYear())).replace("%m", addZeros(time.getMonth() + 1, 2))).replace("%d", addZeros(time.getDate(), 2))).replace("%H", "" + addZeros(time.getHours(), 2))).replace("%M", "" + addZeros(time.getMinutes(), 2))).replace("%S", "" + addZeros(time.getSeconds(), 2))).replace("%I", "" + ((time.getHours() + 11) % 12 + 1))).replace("%p", time.getHours() < 12 ? "AM" : "PM")).replace("%%", "%")) : "";
                function addZeros(value, len) {
                    var i;
                    if ((value = "" + value).length < len) for (i = 0; i < len - value.length; i++) value = "0" + value;
                    return value;
                }
            }
        };
    }(jQuery, Wf), function($, Wf) {
        var counter = 0;
        var instance = {};
        Wf.JSON = {
            request: function(func, data, callback, scope, multi) {
                var json = {
                    method: func,
                    id: function() {
                        for (var guid = new Date().getTime().toString(32), i = 0; i < 5; i++) guid += Math.floor(65535 * Math.random()).toString(32);
                        return "wf_" + guid + (counter++).toString(32);
                    }()
                }, multi = (instance[func] && !multi && instance[func].abort(), 
                callback = callback || $.noop, {}), fields = $(":input", "form").serialize(), data = ("string" === $.type(data) || "array" === $.type(data) ? $.extend(json, {
                    params: "string" === $.type(data) ? Wf.String.encodeURI(data) : $.map(data, function(s) {
                        return s && "string" === $.type(s) ? Wf.String.encodeURI(s) : s;
                    })
                }) : ("object" === $.type(data) && data.json && ($.extend(json, {
                    params: data.json
                }), delete data.json), $.extend(multi, data)), $.isEmptyObject(multi) || (fields += "&" + $.param(multi)), 
                document.location.href);
                function showError(e) {
                    var txt = "";
                    txt = (txt = $.isPlainObject(e) ? e.text || "" : "array" === $.type(e) ? e.join("\n") : e) && txt.replace(/<br([^>]+?)>/, ""), 
                    Wf.Modal.alert(txt);
                }
                data = data.replace(/task=plugin.display/, "task=plugin.rpc"), instance[func] = $.ajax({
                    context: scope || this,
                    url: data,
                    dataType: "text",
                    method: "post",
                    data: "json=" + JSON.stringify(json) + "&" + fields
                }).done(function(o) {
                    var r, s;
                    if (o ? ("string" === $.type(o) && /^[\],:{}\s]*$/.test(o.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g, "@").replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g, "]").replace(/(?:^|:|,)(?:\s*\[)+/g, "")) && (s = JSON.parse(o)) && (o = s), 
                    $.isPlainObject(o) ? (o.error && showError(o.text || o.error.message || ""), 
                    (r = o.result || null) && r.error && r.error.length && showError(r.error || "")) : /[{}]/.test(o) ? showError("The server returned an invalid JSON response.") : showError(o)) : showError("The server returned invalid or missing data."), 
                    instance[func] = null, !$.isFunction(callback)) return r;
                    callback.call(scope || this, r);
                }).fail(function(e, status, txt) {
                    "abort" !== status && Wf.Modal.alert(status || "Server Error - " + txt), 
                    instance[func] = null;
                });
            }
        };
    }(jQuery, Wf), function($, Wf) {
        function calculateWidth(n, cw, ch) {
            var ww = $(n).width() - 60, wh = $(n).height() - 101, ww = Math.min(ww / cw, wh / ch);
            cw = Math.min(cw, Math.floor(cw * ww)), $(".uk-modal-dialog", n).css("max-width", cw + "px");
        }
        Wf.Modal = {
            counter: 0,
            _uid: function(p) {
                return (p || "wf_") + this.counter++;
            },
            dialog: function(title, data, options) {
                return this.open(title, options, data);
            },
            open: function(title, options, html) {
                var footer, div = document.createElement("div"), modal = ((options = $.extend({
                    container: $("form").first().get(0) || "body",
                    classes: "",
                    id: "dialog_" + this._uid(),
                    open: $.noop,
                    close: $.noop,
                    beforeclose: $.noop,
                    buttons: !1,
                    header: !0,
                    label: {
                        confirm: Wf.translate("yes", "Yes"),
                        cancel: Wf.translate("no", "No")
                    }
                }, options)).onOpen && (options.open = options.onOpen), options.onBeforeClose && (options.beforeclose = options.onBeforeClose), 
                options.onClose && (options.close = options.onClose), $(div).addClass("uk-modal"), 
                0 === $(".uk-modal-overlay").length && $(div).append('<div class="uk-modal-overlay uk-position-cover uk-overlay-background"></div>'), 
                $('<div class="uk-modal-dialog" role="dialog" aria-modal="true" aria-label="' + title + '"></div>').appendTo(div));
                return $(modal).addClass(options.classes), options.width && $(modal).width(options.width), 
                options.height && $(modal).height(options.height), $(modal).append('<button type="button" class="uk-modal-close uk-close" aria-label="' + Wf.translate("close", "Close") + '"></button>'), 
                options.header && $(modal).append('<div class="uk-modal-header"><h3>' + title + "</h3></div>"), 
                $('<div class="uk-modal-body uk-overflow-container" id="' + options.id + '"></div>').appendTo(modal).append(html), 
                options.elements && (html = "", html = "string" === $.type(options.elements) && options.elements ? options.elements : function(data) {
                    var html = "";
                    return $.each(data, function(key, value) {
                        value.options ? (html = (html += '<div class="uk-form-row uk-flex">') + '<label class="uk-form-label uk-width-1-5" for="' + key + '">' + (value.label || key) + '</label><div class="uk-form-controls uk-width-4-5"><select id="' + key + '" name="' + key + '">', 
                        $.each(value.options, function(optionValue, optionName) {
                            var selected = "";
                            optionValue.default && value === optionValue.default && (selected = " selected"), 
                            html += '<option value="' + optionValue + '"' + selected + ">" + optionName + "</option>";
                        }), html += "</select></div></div>") : html += '<div class="uk-form-row uk-flex"><label class="uk-form-label uk-width-1-5" for="' + key + '">' + value.label || key + '</label><div class="uk-form-controls uk-width-4-5"><input id="' + key + '" type="text" name="' + key + '" value="' + value.value || '" /></div></div>';
                    }), html;
                }(options.elements), $(".uk-modal-body", modal).append(html)), options.buttons && (footer = $('<div class="uk-modal-footer uk-text-right"></div>'), 
                $.each(options.buttons, function(i, o) {
                    var btn = $('<button class="uk-button uk-margin-small-left" id="' + options.id + "_button_" + i + '"></button>').on("click", function(e) {
                        e.preventDefault(), $.isFunction(o.click) && o.click.call(this, e);
                    }).on("submit", function(e) {
                        e.preventDefault(), e.stopImmediatePropagation();
                    });
                    $.each(o.attributes, function(k, v) {
                        "class" === k ? $(btn).addClass(v) : $(btn).attr(k, v);
                    }), o.text && $(btn).append('<label class="uk-text" for="' + options.id + "_button_" + i + '">' + o.text + "</label>"), 
                    o.icon && $(btn).prepend('<i class="uk-icon ' + o.icon + '" aria-hidden="true"></i>&nbsp;'), 
                    $(footer).append(btn);
                })), $(modal).append(footer), $(div).on("modal.open", function(ev) {
                    $("input[autofocus], button[autofocus]", div).first().trigger("focus"), 
                    options.open.call(this, ev);
                }).on("modal.close", function(e, ev) {
                    options.beforeclose.call(this, ev), $(this).off("modal.open modal.close keyup.modal").removeClass("uk-open"), 
                    $("body").off("keyup.modal"), window.setTimeout(function() {
                        $(div).hide().detach();
                    }, 500), options.close.call(this, ev);
                }), $(".uk-modal-close", div).on("click", function(e) {
                    e.preventDefault(), e.stopImmediatePropagation(), $(div).trigger("modal.close", e);
                }), $(div).on("keydown.modal", function(e) {
                    var $navItems, endIndex, idx;
                    9 === e.keyCode && ($navItems = $(":input:visible", div).not('input[type="file"]').filter(function() {
                        return 0 <= this.getAttribute("tabindex");
                    })).length && ($navItems.attr("tabindex", 0), e.shiftKey && $navItems.reverse(), 
                    endIndex = Math.max(0, $navItems.length - 1), idx = $navItems.index(e.target) + 1, 
                    $navItems.eq(idx = endIndex < idx ? 0 : idx).trigger("focus").attr("tabindex", 1), 
                    e.preventDefault(), e.stopImmediatePropagation());
                }), $(div).on("keyup.modal", function(e) {
                    13 === e.keyCode && (e.preventDefault(), e.stopPropagation(), 
                    ($("button:focus", this).length ? $(this).find(".uk-modal-dialog button:focus") : $(this).find('.uk-modal-dialog button[type="submit"]')).triggerHandler("click"), 
                    !1 !== options.close_on_submit) && $(this).trigger("modal.close");
                }), $(div).appendTo(options.container), $(div).show().scrollTop(0), 
                $(div).addClass("uk-open").trigger("modal.open").attr("aria-hidden", !1), 
                div;
            },
            confirm: function(s, cb, options) {
                s = "<p>" + s + "</p>";
                return options = $.extend(!0, {
                    label: {
                        confirm: Wf.translate("yes", "Yes"),
                        cancel: Wf.translate("no", "No")
                    }
                }, options), options = $.extend(!0, {
                    classes: "uk-modal-confirm",
                    buttons: [ {
                        text: options.label.cancel,
                        icon: "uk-icon-close",
                        click: function(e) {
                            cb.call(this, !1);
                        },
                        attributes: {
                            class: "uk-modal-close"
                        }
                    }, {
                        text: options.label.confirm,
                        icon: "uk-icon-check",
                        click: function(e) {
                            cb.call(this, !0);
                        },
                        attributes: {
                            type: "submit",
                            class: "uk-button-primary uk-modal-close",
                            autofocus: !0
                        }
                    } ]
                }, options || {}), this.open(Wf.translate("confirm", "Confirm"), options, s);
            },
            alert: function(s, options) {
                s = "<p>" + s + "</p>";
                return options = $.extend({
                    label: {
                        confirm: Wf.translate("ok", "Ok")
                    }
                }, options), options = $.extend({
                    classes: "uk-modal-alert",
                    buttons: [ {
                        text: options.label.confirm,
                        attributes: {
                            type: "submit",
                            class: "uk-modal-close",
                            autofocus: !0
                        }
                    } ]
                }, options || {}), this.open(options.title || Wf.translate("alert", "Alert"), options, s);
            },
            prompt: function(title, cb, options) {
                var html = '<div class="uk-form-row uk-grid">', onOpen = (!1 !== (options = $.extend(!0, {
                    id: "dialog-prompt",
                    value: "",
                    text: "",
                    multiline: !1,
                    elements: "",
                    label: {
                        confirm: Wf.translate("ok", "OK"),
                        cancel: Wf.translate("cancel", "Cancel")
                    }
                }, options)).input && (options.text ? html += '<label class="uk-form-label uk-width-3-10" for="' + options.id + '">' + options.text + '</label><div class="uk-form-controls uk-width-7-10 uk-margin-remove">' : html += '<div class="uk-form-controls uk-width-1-1 uk-margin-remove">', 
                options.multiline ? html += '<textarea id="' + options.id + '-input" required autofocus>' + options.value + "</textarea>" : html += '<input id="' + options.id + '-input" type="text" value="' + options.value + '" required autofocus aria-invalid="false" />'), 
                html = html + "</div>" + "</div>", options.open || function() {});
                return options = $.extend(!0, options, {
                    classes: "uk-modal-prompt",
                    buttons: [ {
                        attributes: {
                            type: "submit",
                            class: "uk-button-primary",
                            autofocus: !0
                        },
                        text: options.label.confirm,
                        icon: "uk-icon-check",
                        click: function() {
                            var args = [], $inp = $("#" + options.id + "-input"), v = $inp.val();
                            if ("" === v) return $inp.trigger("focus"), !1;
                            options.elements && $(":input", "#" + options.id).not($inp).each(function() {
                                args.push($(this).val());
                            }), cb.call(this, v, args), !1 !== options.close_on_submit && $inp.parents(".uk-modal").trigger("modal.close");
                        }
                    } ],
                    open: function() {
                        onOpen.call(this, {
                            target: this
                        });
                        var n = document.getElementById(options.id + "-input");
                        n && setTimeout(function() {
                            function validateInput(n) {
                                var stringA, value, b, isValid = !1;
                                n.value && ((value = options.validate(n.value)) && (stringA = n.value, 
                                value = value, stringA = stringA.split(""), b = value.split(""), 
                                !stringA.filter(function(i) {
                                    return !(-1 < b.indexOf(i));
                                }).join("")) && (isValid = !0), $(n).attr("aria-invalid", !isValid));
                            }
                            n.focus(), options.validate && ($(n).on("change keyup", function(e) {
                                validateInput(n);
                            }), validateInput(n)), "INPUT" === n.nodeName && n.setSelectionRange && n.value && n.setSelectionRange(n.value.length, n.value.length);
                        }, 350);
                    }
                }), this.open(title, options, html);
            },
            custom: function(title, cb, options) {
                var onOpen = (options = $.extend(!0, {
                    id: "dialog-custom",
                    value: "",
                    text: "",
                    multiline: !1,
                    elements: "",
                    label: {
                        confirm: Wf.translate("ok", "OK"),
                        cancel: Wf.translate("cancel", "Cancel")
                    }
                }, options)).open || function() {};
                return options = $.extend(!0, options, {
                    classes: "uk-modal-prompt",
                    buttons: [ {
                        attributes: {
                            type: "submit",
                            class: "uk-button-primary",
                            autofocus: !0
                        },
                        text: options.label.confirm,
                        icon: "uk-icon-check",
                        click: function() {
                            var args = [];
                            options.elements && $(":input", "#" + options.id).each(function() {
                                args.push($(this).val());
                            }), cb.call(this, args), !1 !== options.close_on_submit && $(this).parents(".uk-modal").trigger("modal.close");
                        }
                    } ],
                    open: function() {
                        onOpen.call(this, {
                            target: this
                        });
                        var n = document.getElementById(options.id + "-input");
                        n && setTimeout(function() {
                            function validateInput(n) {
                                var stringA, value, b, isValid = !1;
                                n.value && ((value = options.validate(n.value)) && (stringA = n.value, 
                                value = value, stringA = stringA.split(""), b = value.split(""), 
                                !stringA.filter(function(i) {
                                    return !(-1 < b.indexOf(i));
                                }).join("")) && (isValid = !0), $(n).attr("aria-invalid", !isValid));
                            }
                            n.focus(), options.validate && ($(n).on("change keyup", function(e) {
                                validateInput(n);
                            }), validateInput(n)), "INPUT" === n.nodeName && n.setSelectionRange && n.value && n.setSelectionRange(n.value.length, n.value.length);
                        }, 350);
                    }
                }), this.open(title, options, "");
            },
            upload: function(options) {
                var div = $('<div id="upload-body" />').append('<div id="upload-queue-block" class="uk-placeholder uk-margin-bottom">   <div id="upload-queue"></div>   <input type="file" size="40" tabindex="-1" /></div><div id="upload-options" class="uk-placeholder uk-placeholder-small"></div>');
                return options.upload = options.upload || $.noop, options = $.extend({
                    classes: "uk-modal-dialog-full uk-modal-upload",
                    resizable: !1,
                    buttons: [ {
                        text: Wf.translate("close", "Close"),
                        icon: "uk-icon-close",
                        attributes: {
                            class: "uk-modal-close uk-hidden-small"
                        }
                    }, {
                        text: Wf.translate("browse", "Add Files"),
                        icon: "uk-icon-search",
                        attributes: {
                            id: "upload-browse",
                            class: "uk-button-success",
                            autofocus: !0
                        }
                    }, {
                        text: Wf.translate("upload", "Upload"),
                        click: function(e) {
                            return e.preventDefault(), options.upload.call();
                        },
                        attributes: {
                            id: "upload-start",
                            class: "uk-button-primary"
                        },
                        icon: "uk-icon-cloud-upload"
                    } ]
                }, options), this.open(Wf.translate("upload", "Upload"), options, div);
            },
            iframe: function(name, url, options) {
                var div = document.createElement("div");
                var w = options.width, h = options.height, name = (options = $.extend({
                    classes: "uk-modal-dialog-large uk-modal-preview",
                    open: function(e) {
                        var wh, cw, ch, iframe = document.createElement("iframe");
                        $(div).addClass("loading"), $(iframe).attr({
                            src: url,
                            scrolling: "auto",
                            frameborder: 0
                        }).on("load", function() {
                            $.isFunction(options.onFrameLoad) && options.onFrameLoad.call(this), 
                            $(div).removeClass("loading");
                        }), $(div).addClass("iframe-preview").append(iframe), iframe = e.target, 
                        e = $(".uk-modal-dialog", iframe).outerHeight(), wh = $(iframe).height(), 
                        cw = $(".uk-modal-body", iframe).width(), ch = $(".uk-modal-body", iframe).height(), 
                        e = e - $(".uk-modal-body", iframe).height() + ch, cw = Math.min(cw, Math.floor(cw * Math.min(wh / e, 1))), 
                        $(".uk-modal-dialog", iframe).css("max-width", cw - 20 + "px"), 
                        w = cw, .56 !== parseFloat((h / w).toFixed(2)) && (ch = Math.floor(h / w * 100), 
                        $(div).css("padding-bottom", "calc(" + ch + "% - 20px)"));
                    }
                }, options), name || Wf.translate("preview", "Preview"));
                return this.open(name, options, div);
            },
            media: function(name, url, options) {
                var w = (options = options || {}).width, h = options.height, div = document.createElement("div");
                return delete options.width, delete options.height, $.extend(options, {
                    classes: "uk-modal-dialog-large uk-modal-preview",
                    open: function(e) {
                        if (/\.(jpg|jpeg|gif|png|apng|svg|webp)/i.test(url)) {
                            $(div).addClass("image-preview loading");
                            var img = new Image(), loaded = !1;
                            img.onload = function() {
                                if (loaded) return !1;
                                w = w || img.width, h = h || img.height, $(".image-preview").removeClass("loading").append('<img src="' + url + '" alt="' + Wf.String.basename(url) + '" />').parent().css("max-width", w + "px"), 
                                loaded = !0, calculateWidth(e.target, w, h), $(".image-preview").on("click", function(e) {
                                    $(e.target).trigger("modal.close", e);
                                }), window.setTimeout(function() {
                                    $(".uk-modal").trigger("modal.assetloaded");
                                }, 0);
                            }, /\?/.test(url) || (url += "?" + new Date().getTime()), 
                            img.src = url;
                        } else if (/\.pdf$/i.test(url)) $(div).addClass("media-preview loading"), 
                        ($.support.pdf ? $(div).html('<object data="' + url + '" type="application/pdf"></object>') : $(div).html('<iframe src="' + url + '" frameborder="0"></iframe>')).removeClass("big-loader"), 
                        $("iframe, object", div).on("load", function() {
                            calculateWidth(e.target, w, h), $(".uk-modal").trigger("modal.assetloaded");
                        }); else {
                            $(div).addClass("media-preview loading");
                            var mimes = {};
                            !function() {
                                for (var y, ext, items = "application/x-director,dcr,application/x-mplayer2,wmv wma avi,video/divx,divx,application/x-shockwave-flash,swf swfl,audio/mpeg,mpga mpega mp2 mp3,audio/ogg,ogg spx oga,audio/x-wav,wav,video/mpeg,mpeg mpg mpe,video/mp4,mp4 m4v,video/ogg,ogg ogv,video/webm,webm,video/quicktime,qt mov,video/x-flv,flv,video/vnd.rn-realvideo,rv,video/3gpp,3gp,video/x-matroska,mkv".split(/,/), i = 0; i < items.length; i += 2) for (ext = items[i + 1].split(/ /), 
                                y = 0; y < ext.length; y++) mimes[ext[y]] = items[i];
                            }();
                            var type, props, ext = (ext = Wf.String.getExt(url)).toLowerCase(), mt = mimes[ext];
                            if ($.each({
                                flash: {
                                    classid: "clsid:d27cdb6e-ae6d-11cf-96b8-444553540000",
                                    type: "application/x-shockwave-flash",
                                    codebase: "http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,40,0"
                                },
                                shockwave: {
                                    classid: "clsid:166b1bca-3f9c-11cf-8075-444553540000",
                                    type: "application/x-director",
                                    codebase: "http://download.macromedia.com/pub/shockwave/cabs/director/sw.cab#version=8,5,1,0"
                                },
                                windowsmedia: {
                                    classid: "clsid:6bf52a52-394a-11d3-b153-00c04f79faa6",
                                    type: "application/x-mplayer2",
                                    codebase: "http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#Version=5,1,52,701"
                                },
                                quicktime: {
                                    classid: "clsid:02bf25d5-8c17-4b23-bc80-d3488abddc6b",
                                    type: "video/quicktime",
                                    codebase: "http://www.apple.com/qtactivex/qtplugin.cab#version=6,0,2,0"
                                },
                                divx: {
                                    classid: "clsid:67dabfbf-d0ab-41fa-9c46-cc0f21721616",
                                    type: "video/divx",
                                    codebase: "http://go.divx.com/plugin/DivXBrowserPlugin.cab"
                                },
                                realmedia: {
                                    classid: "clsid:cfcdaa03-8be4-11cf-b84b-0020afbbccfa",
                                    type: "audio/x-pn-realaudio-plugin"
                                },
                                java: {
                                    classid: "clsid:8ad9c840-044e-11d1-b3e9-00805f499d93",
                                    type: "application/x-java-applet",
                                    codebase: "http://java.sun.com/products/plugin/autodl/jinstall-1_5_0-windows-i586.cab#Version=1,5,0,0"
                                },
                                silverlight: {
                                    classid: "clsid:dfeaf541-f3e1-4c24-acac-99c30715084a",
                                    type: "application/x-silverlight-2"
                                },
                                video: {
                                    type: "video/mp4"
                                },
                                audio: {
                                    type: "audio/mp3"
                                }
                            }, function(k, v) {
                                v.type && v.type == mt && (type = k, props = v);
                            }), /^(mp4|m4v|og(g|v)|webm|flv|f4v)$/i.test(ext) && (type = "video", 
                            props = {
                                type: mt
                            }), /^(mp3|oga)$/i.test(ext) && (type = "audio", props = {
                                type: mt
                            }), type && props) {
                                switch (type) {
                                  case "audio":
                                  case "video":
                                    "video" == type ? $(div).append('<video autoplay="autoplay" controls="controls" preload="none" type="' + props.type + '" src="' + url + '"></video>') : $(div).addClass("media-preview-audio").append('<audio autoplay="autoplay" controls="controls" preload="none" type="' + props.type + '" src="' + url + '"></audio>');
                                    break;

                                  case "flash":
                                    $(div).append('<object type="' + props.type + '" data="' + url + '"><param name="movie" value="' + url + '" /></object>');
                                    break;

                                  default:
                                    $(div).append('<object classid="' + props.classid + '"><param name="src" value="' + url + '" /><embed src="' + url + '" type="' + props.type + '"></embed></object>');
                                }
                                $("iframe, object, embed, video, audio", div).on("load loadedmetadata", function() {
                                    $(div).removeClass("loading"), calculateWidth(e.target, w, h), 
                                    $(".uk-modal").trigger("modal.assetloaded");
                                }).on("error", function() {
                                    $(div).removeClass("loading");
                                });
                            }
                        }
                        calculateWidth(e.target, w, h);
                    }
                }), this.open(name, options, div);
            }
        };
    }(jQuery, Wf), function($) {
        $.extend(Wf, {
            getAttrib: function(e, at) {
                var v, ed = tinyMCEPopup.editor;
                switch (at) {
                  case "width":
                  case "height":
                    -1 !== (v = ed.dom.getAttrib(e, at) || e.style[at] || "").indexOf("px") && (v = parseInt(v, 10));
                    break;

                  case "align":
                    if (v = ed.dom.getAttrib(e, "align")) return v;
                    if (v = ed.dom.getStyle(e, "float")) return v;
                    if (v = ed.dom.getStyle(e, "vertical-align")) return v;
                    if ("block" === e.style.display && "auto" === ed.dom.getStyle(e, "margin-left") && "auto" === ed.dom.getStyle(e, "margin-right")) return "center";
                    break;

                  case "margin-top":
                  case "margin-bottom":
                    if (v = ed.dom.getStyle(e, at)) return /auto|inherit/.test(v) || /[a-z%]/i.test(v) && -1 === v.indexOf("px") ? v : parseInt(v, 10);
                    if (v = ed.dom.getAttrib(e, "vspace")) return parseInt(v.replace(/[^-0-9]/g, ""), 10);
                    break;

                  case "margin-left":
                  case "margin-right":
                    if (v = ed.dom.getStyle(e, at)) return /auto|inherit/.test(v) || /[a-z%]/i.test(v) && -1 === v.indexOf("px") ? v : parseInt(v, 10);
                    if (v = ed.dom.getAttrib(e, "hspace")) return parseInt(v.replace(/[^-0-9]/g, ""), 10);
                    break;

                  case "border-width":
                  case "border-style":
                  case "border-color":
                    v = "", tinymce.each([ "top", "right", "bottom", "left" ], function(n) {
                        n = at.replace(/-/, "-" + n + "-"), n = ed.dom.getStyle(e, n);
                        ("" !== n || n != v && "" !== v) && (v = ""), n && (v = n);
                    }), "" !== v && $("#border").prop("checked", !0), "border-width" != at && "border-style" != at || "" !== v || (v = "inherit"), 
                    "border-color" == at && (v = Wf.String.toHex(v)), "border-width" == at && /[0-9][a-z]/.test(v) && (v = parseFloat(v));
                }
                return v;
            },
            setMargins: function() {},
            setBorder: function() {},
            setDimensions: function() {},
            setStyles: function() {
                var border, ed = tinyMCEPopup.editor, $img = $("#sample");
                $img.length && ($img.attr("style", $("#style").val()), $.each([ "top", "right", "bottom", "left" ], function(i, k) {
                    var v = ed.dom.getStyle($img.get(0), "margin-" + k);
                    v && -1 != v.indexOf("px") && (v = parseInt(v, 10)), $("#margin_" + k).val(v);
                }), this.setMargins(!0), border = !1, $.each([ "width", "color", "style" ], function(i, k) {
                    var v = ed.dom.getStyle($img.get(0), "border-" + k);
                    "" == v && $.each([ "top", "right", "bottom", "left" ], function(i, n) {
                        n = ed.dom.getStyle($img.get(0), "border-" + n + "-" + k);
                        ("" !== n || n != v && "" !== v) && (v = ""), n && (v = n);
                    }), "" !== v && (border = !0), "width" == k && (v = /[0-9][a-z]/.test(v) ? parseInt(v, 10) : v), 
                    "color" == k && v && "#" === (v = Wf.String.toHex(v)).charAt(0) && (v = v.substr(1)), 
                    border && ($("#border_" + k).val(v), $("#border~:input, #border~span, #border~label").attr("disabled", !1).toggleClass("uk-text-muted", !1), 
                    "color" == k && $("#border_" + k).trigger("pick"), $("#border").prop("checked", !0).trigger("change"));
                }), $("#align").val(function() {
                    var v = $img.css("float") || $img.css("vertical-align");
                    return v || ("auto" === $img.css("margin-left") && "auto" === $img.css("margin-right") && "block" === $img.css("display") ? "center" : "");
                }));
            },
            updateStyles: function() {
                var v, k, n, s, ed = tinyMCEPopup.editor, img = new Image(), preview = $("#sample"), styles = ($(img).attr("style", $("#style").val()), 
                $(img).add(preview).attr("dir", $("#dir").val()), $(img).add(preview).css("float", ""), 
                "center" == (v = $("#align").val()) ? ($(img).add(preview).css({
                    display: "block",
                    "margin-left": "auto",
                    "margin-right": "auto"
                }), $(img).add(preview).css({
                    float: "",
                    "vertical-align": ""
                }), $("#clear").attr("disabled", !0).trigger("datalist:disabled", !0), 
                $("#margin_left, #margin_right").val("auto")) : (/(top|middle|bottom)/.test(v) && $(img).add(preview).css("vertical-align", v), 
                $(img).add(preview).css("float", v).css("display", function() {
                    return "block" === this.style.display && "auto" === this.style.marginLeft && "auto" === this.style.marginRight ? "" : this.style.display;
                }), $("#margin_left, #margin_right").val(function() {
                    return "auto" === this.value ? "" : this.value;
                }), $("#margin_check").is(":checked") && $("#margin_top").siblings('input[type="text"]').val($("#margin_top").val()), 
                $("#clear").attr("disabled", !v).trigger("datalist:disabled", !v)), 
                (v = $("#clear:enabled").val()) ? ($("#sample-br").get(0) || $(img).add(preview).after('<br id="sample-br" />'), 
                $("#sample-br").css("clear", v)) : $("#sample-br").remove(), $.each([ "width", "color", "style" ], function(i, k) {
                    "inherit" == (v = $("#border").is(":checked") ? $("#border_" + k).val() : "") && (v = ""), 
                    "width" == k && /[^a-z]/i.test(v) && (v += "px"), "color" == k && "#" !== v.charAt(0) && (v = "#" + v), 
                    $(img).add(preview).css("border-" + k, v);
                }), $.each([ "top", "right", "bottom", "left" ], function(i, k) {
                    (v = $("#margin_" + k).val()) && !/[a-z%]/i.test(v) && (v += "px"), 
                    $(img).add(preview).css("margin-" + k, v);
                }), ed.dom.parseStyle($(img).attr("style")));
                for (k in n = [ "width", "style", "color", "image" ], s = [], $.each(n, function(i, k) {
                    "none" == (v = styles[k = "border-" + k]) ? delete styles[k] : v && (s.push(styles[k]), 
                    delete styles[k]);
                }), s.length && (styles.border = s.join(" ")), styles) (0 <= k.indexOf("-moz-") || 0 <= k.indexOf("-webkit-")) && delete styles[k];
                $("#style").val(ed.dom.serializeStyle(styles));
            },
            setDefaults: function(s) {
                var n, v, $elm, x = 0;
                for (n in s) n && ("default" === (v = s[n]) && (v = ""), ($elm = $("#" + (n = "direction" === n ? "dir" : n))).length ? $elm.is(":checkbox") ? $("#" + n).prop("checked", parseFloat(v)) : ($("#" + n).val(v), 
                "string" == typeof v && "#" === v.charAt(0) && $("#" + n).trigger("change")) : ($elm = $(".uk-repeatable", "#custom_attributes"), 
                0 < x && $elm.eq(0).clone(!0).appendTo($elm.parent()), ($elm = $elm.eq(x).find("input, select")).eq(0).val(n), 
                $elm.eq(1).val(v), x++));
            }
        });
    }(jQuery), function($, Wf) {
        function Tree(element, options) {
            this.element = element, this.options = $.extend({
                collapseTree: !1,
                charLength: !1
            }, options), this._init();
        }
        var scrollEvents = "click.scroll mousedown.scroll wheel.scroll mousewheel.scroll keyup.scroll touchmove.scroll";
        Tree.prototype = {
            _trigger: function(ev, args) {
                $(this.element).trigger("tree:" + ev, args);
            },
            _init: function() {
                var self = this;
                this.element && (this._trigger("init", function() {
                    self.nodeEvents();
                }), $(this.element).on(scrollEvents, function() {
                    $(this).stop();
                }));
            },
            nodeEvents: function(parent) {
                var self = this;
                parent = parent || this.element, $("ul:first", parent).attr({
                    role: "tree"
                }).addClass("uk-tree").children("li").attr("aria-level", 1), $(".uk-tree", parent).on("click", function(e) {
                    var n = e.target, p = $(n).parents("li").get(0);
                    e.preventDefault(), e.stopPropagation(), $(n).hasClass("uk-icon") && (n = n.parentNode), 
                    $(n).hasClass("uk-tree-toggle") ? self.toggleNode(e, p) : self._trigger("nodeclick", [ e, p ]), 
                    $(self.element).find(".uk-tree-active").removeClass("uk-tree-active"), 
                    $(p).addClass("uk-tree-active");
                }), $("li", parent).attr({
                    role: "treeitem"
                }).attr("aria-expanded", function() {
                    return !!$(this).hasClass("uk-tree-open");
                }).attr("aria-level", function(i, v) {
                    if (!v) return parseFloat($(this.parentNode.parentNode).attr("aria-level")) + 1;
                }), $("li", parent).find(".uk-tree-row").attr("role", "presentation").prepend('<span class="uk-tree-toggle" role="presentation"><i class="uk-icon uk-icon-caret-right"></i><i class="uk-icon uk-icon-caret-down"></i></span>'), 
                $("li", parent).not(".uk-tree-root").find(".uk-tree-icon").attr("role", "presentation").append('<i class="uk-icon uk-icon-folder"></i><i class="uk-icon uk-icon-folder-open"></i>');
            },
            _hasNodes: function(parent) {
                "string" == $.type(parent) && (parent = this._findParent(parent));
                parent = $("li", parent);
                return 1 < parent.length || 1 == parent.length && !$(parent).is(":empty");
            },
            _isNode: function(id, parent) {
                return !!this._findNode(id, parent).length;
            },
            _getNode: function(parent) {
                return "string" === $.type(parent) && (parent = this._findParent(parent)), 
                $(".uk-tree-node", parent);
            },
            _resetNodes: function() {
                $("li", this.element).removeClass("uk-tree-open");
            },
            renameNode: function(id, name) {
                var parent = Wf.String.dirname(id), parent = this._findNode(id, parent);
                $(parent).attr("data-id", name), $("a:first .uk-tree-text", parent).text(Wf.String.basename(name)), 
                $('li[data-id^="' + this._escape(encodeURI(id)) + '"]', parent).each(function(n) {
                    var nt = $(n).attr("data-id");
                    $(n).attr("data-id", nt.replace(id, name));
                });
            },
            removeNode: function(id) {
                var parent = Wf.String.dirname(id), id = this._findNode(id, parent), parent = $(id).parent("ul");
                $(id).remove(), parent && !this._hasNodes(parent) && $(parent).remove();
            },
            sortNodes: function(parent) {
                var p = $(parent).parent(), list = (parent = $(parent).detach(), 
                $("li", parent).map(function() {
                    return {
                        value: $(".uk-tree-text", this).attr("title"),
                        element: this
                    };
                }).get());
                list.sort(function(a, b) {
                    a = a.value || "", b = b.value || "";
                    return a.localeCompare(b);
                }), $.each(list, function(i, item) {
                    $(parent).append(item.element);
                }), $(p).append(parent);
            },
            createNode: function(nodes, parent, sortNodes) {
                var ul, self = this;
                nodes.length && (parent = parent || Wf.String.dirname($(nodes[0]).attr("data-id") || $(nodes[0]).attr("id")), 
                "string" == $.type(parent) && (parent = this._findParent(parent)), 
                nodes = $.grep(nodes, function(node) {
                    return 0 === self._findNode(node.id, parent).length;
                }), $(this.element).find(".uk-tree-active").removeClass("uk-tree-active"), 
                nodes && nodes.length ? ((ul = $(".uk-tree-node:first", parent) || null).length || (ul = document.createElement("ul"), 
                $(ul).attr({
                    role: "group"
                }).addClass("uk-tree-node").append('<li role="treeitem" aria-expanded="false"></li>'), 
                $(parent).append(ul)), $.each(nodes, function(i, node) {
                    var name, title, url, html;
                    self._isNode(node.id, parent) ? self.toggleNodeState(parent, 1) : (title = node.name || node.id, 
                    name = Wf.String.decode(title), title = Wf.String.encode(title), 
                    url = node.url || "#", node.class || (node.class = "folder"), 
                    html = '<li data-id="' + self._escape(encodeURI(node.id)) + '" class="' + node.class + '" role="treeitem" aria-level="' + parseFloat($(parent).attr("aria-level")) + '1" aria-label="' + title + '">', 
                    html += '<div class="uk-tree-row">', 0 <= node.class.indexOf("folder") && (html += '<span class="uk-tree-toggle" role="presentation"> <i class="uk-icon uk-icon-caret-right"></i> <i class="uk-icon uk-icon-caret-down"></i></span>'), 
                    html += '<a href="' + url + '" title="' + title + '"><span class="uk-tree-icon">', 
                    0 <= node.class.indexOf("folder") ? html += '<i role="presentation" class="uk-icon uk-icon-folder"></i><i role="presentation" class="uk-icon uk-icon-folder-open"></i>' : html += '<i role="presentation" class="uk-icon uk-icon-file-text"></i>', 
                    html = html + '</span><span class="uk-tree-text uk-margin-small-left uk-text-truncate" title="' + title + '">' + name + "</span></a></div></li>", 
                    $(ul).append(html), self.toggleNodeState(parent, 1), self._trigger("nodecreate"));
                }), !1 !== sortNodes && 1 < $(ul).children().length && self.sortNodes(ul)) : this.toggleNodeState(parent, 1));
            },
            _findParent: function(el) {
                return "string" === $.type(el) ? $('li[data-id="' + this._encode(el) + '"]:first', this.element) : $(el).parents("li:first");
            },
            _findNode: function(id, parent) {
                return parent && "/" !== parent || (parent = this.element), "string" === $.type(parent) && (parent = this._findParent(parent)), 
                id = id.replace(/^\/|\/$/, ""), $(parent).find('li[data-id="' + this._escape(this._encode(id)) + '"]:first');
            },
            toggleLoader: function(node) {
                $(node).toggleClass("uk-tree-loading");
            },
            _collapseNodes: function(ex) {
                var self = this, parent = (ex || this._resetNodes(), $(ex).parent());
                $("li", parent).each(function(i, el) {
                    el !== ex && $(el).parent() !== parent && (self.toggleNodeState(el, 0), 
                    el = self._getNode(el), $(el).addClass("uk-tree-hide"));
                });
            },
            toggleNodeState: function(node, state) {
                state ? $(node).addClass("uk-tree-open").attr("aria-expanded", !0) : $(node).removeClass("uk-tree-open").attr("aria-expanded", !1), 
                state && !$(node).hasClass("uk-tree-root") && (state = $(".uk-tree-node", node), 
                $(node).hasClass("uk-tree-open") ? $(state).removeClass("uk-tree-hide") : $(state).addClass("uk-tree-hide"));
            },
            toggleNode: function(e, node) {
                if (e.shiftKey) return this._trigger("nodeload", node);
                e = this._getNode(node);
                e.length ? ($(e).toggleClass("uk-tree-hide"), this.toggleNodeState(node, !$(e).hasClass("uk-tree-hide"))) : $(node).hasClass("uk-tree-open") ? this.toggleNodeState(node, 0) : this._trigger("nodeload", node), 
                this.options.collapseTree && this._collapseNodes(node);
            },
            refreshNode: function(node) {
                node = this._findParent(node);
                return this._trigger("nodeload", node);
            },
            _encode: function(s) {
                try {
                    s = decodeURIComponent(s);
                } catch (e) {}
                return encodeURIComponent(s).replace(/%2F/gi, "/");
            },
            _escape: function(s) {
                return s.replace(/'/g, "%27");
            },
            scrollTo: function(id) {
                var padding, top, el = this.element, id = this._findNode(id);
                $(id).length && (padding = parseInt($(id).css("padding-left"), 10) + parseInt($(this.element).css("padding-left"), 10), 
                padding = $(id).get(0).offsetLeft - padding, top = $(id).get(0).offsetTop - ($(".uk-tree-row", id).outerHeight() + 2), 
                $(el).find(".uk-tree-active").removeClass("uk-tree-active"), $(el).animate({
                    scrollLeft: Math.round(padding)
                }, 500).animate({
                    scrollTop: Math.round(top)
                }, 1500, function() {
                    $(this).off(scrollEvents);
                }), $(id).addClass("uk-tree-active"));
            }
        }, $.fn.tree = function(options) {
            var inst = new Tree(this, options);
            return $(this).on("tree:createnode", function(e, node, parent, sortNodes) {
                inst.createNode(node = "string" == typeof node ? [ node ] : node, parent, sortNodes);
            }), $(this).on("tree:removenode", function(e, node) {
                inst.removeNode(node);
            }), $(this).on("tree:renamenode", function(e, node, name) {
                inst.renameNode(node, name);
            }), $(this).on("tree:togglenode", function(e, ev, node) {
                inst.toggleNode(ev, node);
            }), $(this).on("tree:togglenodestate", function(e, node, state) {
                inst.toggleNodeState(node, state);
            }), $(this).on("tree:toggleloader", function(e, node) {
                inst.toggleLoader(node);
            }), $(this).on("tree:refreshnode", function(e, node) {
                inst.refreshNode(node);
            }), $(this).on("tree:scroll", function(e, id) {
                inst.scrollTo(id);
            }), $(this).on("tree:init", function(e) {
                inst.nodeEvents();
            }), this;
        };
    }(jQuery, Wf);
    window.WFExtensions = {
        types: {},
        add: function(n, o) {
            return this[n] = o, this[n];
        },
        addType: function(n) {
            this.types[n] = {};
        },
        addExtension: function(type, n, o) {
            void 0 === this.types[type] && this.addType(type), this.types[type][n] = o;
        },
        getType: function(type) {
            return this.types[type] || !1;
        },
        getExtension: function(type, ext) {
            return this.getType(type)[ext];
        }
    };
    var ColorPicker, WFAggregator = WFExtensions.add("Aggregator", {
        aggregators: {},
        add: function(name, o) {
            this.aggregators[name] = o || {};
        },
        get: function(name) {
            return this.aggregators[name] || null;
        },
        setup: function(options) {
            var self = this;
            options = options || {}, tinymce.each(this.aggregators, function(o, k) {
                return self.setParams(o, options), self._call(o, "setup");
            });
        },
        getTitle: function(name) {
            var f = this.get(name);
            return f ? f.title : name;
        },
        getType: function(name) {
            name = this.get(name);
            return name ? name.getType() : "";
        },
        getValues: function(name, data) {
            name = this.get(name);
            if (name) return this._call(name, "getValues", data);
        },
        setValues: function(name, data) {
            name = this.get(name);
            if (name) return this._call(name, "setValues", data);
        },
        getAttributes: function(name, args) {
            name = this.get(name);
            if (name) return this._call(name, "getAttributes", args);
        },
        setAttributes: function(name, args, callback) {
            var name = this.get(name);
            if (name) return name = this._call(name, "setAttributes", args), "function" == typeof callback && callback(name), 
            name;
        },
        isSupported: function(args) {
            var r, v, self = this;
            return tinymce.each(this.aggregators, function(o) {
                (v = self._call(o, "isSupported", args)) && (r = v);
            }), r;
        },
        getParam: function(name, param) {
            name = this.get(name);
            return name && name.params[param] || "";
        },
        setParams: function(name, o) {
            name = this.get(name);
            name && tinymce.extend(name.params, o);
        },
        onSelectFile: function(name) {
            name = this.get(name);
            if (name) return this._call(name, "onSelectFile");
        },
        onInsert: function(name) {
            name = this.get(name);
            if (name) return this._call(name, "onInsert");
        },
        _call: function(o, fn, vars) {
            return (o[fn] || function() {}).call(o, vars);
        }
    }), WFAggregator = (window.WFAggregator = WFAggregator, WFExtensions.add("Popups", {
        popups: {},
        popup: "",
        config: {},
        addPopup: function(n, o) {
            this.popups[n] = o, WFExtensions.addExtension("popups", n, o);
        },
        getPopups: function() {
            return this.popups;
        },
        setup: function(options) {
            var n, state, self = this, ed = tinyMCEPopup.editor, s = ed.selection;
            options = $.extend({
                remove: $.noop,
                change: $.noop
            }, options || {}), $("#popup_list").on("change", function() {
                self.selectPopup(this.value), options.change(this.value);
            }).on("popup:remove", function(e, n) {
                options.remove(n);
            }).trigger("change"), s.isCollapsed() || (n = s.getNode(), state = !0, 
            s = s.getContent({
                format: "text"
            }), function(state, v) {
                state && v ? ($("#popup_text").val(v), $("#popup_text").attr("disabled", !1)) : ($("#popup_text").val(tinyMCEPopup.getLang("dlg.element_selection", "Element Selection")), 
                $("#popup_text").attr("disabled", !0), $("#popup_text").addClass("disabled"));
            }(state = n ? 1 == (n = tinymce.grep(n.childNodes, function(node) {
                return 0 == ed.dom.is(node, "br[data-mce-bogus]");
            })).length && 3 == n[0].nodeType : state, s)), $.each(this.popups, function(k, v) {
                self._call("setup", "", v);
            });
        },
        isPopup: function(n, v) {
            return n && "A" == n.nodeName && this._call("check", n, v);
        },
        getPopup: function(n, callback, index) {
            var self = this, ed = tinyMCEPopup.editor;
            return "A" != n.nodeName && (n = ed.dom.getParent(n, "a")), $.each(this.popups, function(k, v) {
                self.isPopup(n, k) && (self.popup = k);
            }), n && this.popup ? (this.selectPopup(this.popup), this.getAttributes(n, index, callback)) : "";
        },
        setPopup: function(s) {
            this.popup = s;
        },
        setConfig: function(config) {
            $.extend(this.config, config);
        },
        setParams: function(n, p) {
            n = this.popups[n];
            n && (void 0 === n.params && (n.params = {}), $.extend(n.params, p));
        },
        getParams: function(n) {
            return this.popups[n].params || {};
        },
        getParam: function(n, p) {
            return this.getParams(n)[p] || null;
        },
        selectPopup: function(v) {
            this.popup = v, $("#popup_list").val(v).children("option").each(function() {
                this.value && $("#popup_extension_" + this.value).hide();
            }), v && ($("#popup_extension_" + v).show(), this._call("onSelect", [], v));
        },
        setAttributes: function(n, args, index) {
            var ed = tinyMCEPopup.editor;
            return this.config.map && $.each(this.config.map, function(to, from) {
                var v = args[from] || $("#" + from).val();
                ed.dom.setAttrib(n, to, v), delete args[from];
            }), this._call("setAttributes", [ n, args, index ]);
        },
        getAttributes: function(n, callback, index) {
            var data, ed = tinyMCEPopup.editor;
            return callback = callback || function(val) {
                return val;
            }, index = index || 0, data = (n = !n && "A" == n.nodeName ? n : ed.dom.getParent(n, "a")) && this.isPopup(n) ? this._call("getAttributes", [ n, index, callback ]) : data;
        },
        isEnabled: function() {
            return this.popup;
        },
        createPopup: function(n, args, index) {
            var se, self = this, ed = tinyMCEPopup.editor;
            args = args || {}, this.isEnabled() ? n && ("A" == n.nodeName || ed.dom.getParent(n, "A")) ? ("A" != n.nodeName && (n = ed.dom.getParent(n, "A")), 
            this.removePopups(n, !0), this.setAttributes(n, args, index)) : ((se = ed.selection).isCollapsed() ? ed.execCommand("mceInsertContent", !1, '<a href="#" id="__mce_tmp">' + $("#popup_text").val() + "</a>", {
                skip_undo: 1
            }) : (n = n || se.getNode(), ed.execCommand("mceInsertLink", !1, {
                href: "#",
                id: "__mce_tmp"
            }, {
                skip_undo: 1
            }), ed.dom.setAttrib(n, "style", ed.dom.getAttrib(n, "data-mce-style"))), 
            (n = ed.dom.get("__mce_tmp")) && (ed.dom.setAttrib(n, "id", null), self.setAttributes(n, args, index))) : (n = ed.dom.getParent(n, "A"), 
            $.each(this.popups, function(k, v) {
                if (self.isPopup(n, k)) return self.removePopups(n), !1;
            }));
        },
        removePopups: function(n, no_event) {
            var self = this;
            $.each(this.popups, function(k, v) {
                self._call("remove", n, k);
            }), no_event || $("#popup_list").trigger("popup:remove", n);
        },
        onSelectFile: function(args) {
            this._call("onSelectFile", args);
        },
        _call: function(fn, args, popup) {
            return "function" == typeof (fn = (popup = "string" == typeof (popup = popup || this.popup) ? this.popups[popup] || {} : popup)[fn]) && ("array" === $.type(args) ? fn.apply(popup, args) : fn.call(popup, args));
        }
    }));
    window.WFPopups = WFAggregator;
}();