<?php
/**
 * HsConfig Model for Highslide Configuration Component
 *
 * @license		GNU/GPL
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport('joomla.application.component.model');

class HsConfigsModelHsConfig extends JModel
{

	var $_articleList = null;

	/**
	 * Constructor that retrieves the ID from the request
	 *
	 * @access	public
	 * @return	void
	 */
	function __construct()
	{
		parent::__construct();

		$array = JRequest::getVar('cid',  0, '', 'array');
		$this->setId((int)$array[0]);
	}

	/**
	 * Method to set the hsconfig identifier
	 *
	 * @access	public
	 * @param	int Hsconfig identifier
	 * @return	void
	 */
	function setId($id)
	{
		// Set id and wipe data
		$this->_id		= $id;
		$this->_data	= null;
	}


	/**
	 * Method to get a hsconfig
	 * @return object with data
	 */
	function &getData()
	{
		jimport('joomla.filesystem.file');
		// Load the data
		if (empty( $this->_data )) {
			$query = ' SELECT a.*, b.title FROM #__hsconfig a '.
					 ' LEFT JOIN #__content b '.
					 ' ON a.id = b.id '.
					'  WHERE a.id = '.$this->_id;
			$this->_db->setQuery( $query );
			$this->_data = $this->_db->loadObject();
		}
		if (!$this->_data) {
			$this->_data = new stdClass();
			$this->_data->id = 0;
			$this->_data->css = null;
			$this->_data->overlayhtml = null;
			$this->_data->params = null;
			$this->_data->published = false;
			$filename = JPATH_ADMINISTRATOR.DS.'components'.DS.'com_hsconfig'.DS.'css'.DS.'default.css';
			if (JFILE::exists($filename))
			{
				$this->_data->css = JFILE::read($filename);
			}
		}
		if ($this->_state->task == 'copy')
		{
			$this->_data->id = 0;
		}
		return $this->_data;
	}

	function &getArticleList()
	{
		$query = ' SELECT a.id, a.title from #__content as a '
		        .' LEFT JOIN #__hsconfig as b on a.id = b.id '
		        .' WHERE b.modified is null';
		$this->_db->setQuery( $query );
		$this->_articleList = $this->_db->loadObjectList();
		return $this->_articleList;
	}

	/**
	 * Method to store a record
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	function store()
	{
		$data = JRequest::get( 'post' );
		$isnew = false;

		if ($data['id'] == 0)
		{
			$data['id'] = $data['cid'];
			$isnew = true;
		}
		$row =& $this->getTable();

		// Bind the form fields to the hsconfig table
		if (!$row->bind($data)) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		// Make sure the hsconfig record is valid
		if (!$row->check()) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		$row->published = HsConfigHelper::isPublished( $row->id );

		$datenow =& JFactory::getDate();
		$row->modified = $datenow->toMySQL();

		if ($isnew)
		{
			if (!$row->_db->insertObject( $row->_tbl, $row, $row->_tbl_key ))
			{
				$row->setError(get_class( $row ).'::store failed - '.$row->_db->getErrorMsg());
				$this->setError( $this->_db->getErrorMsg());
				return false;
			}
		}
		else
		{
			// Store the web link table to the database
			if (!$row->store()) {
				$this->setError( $this->_db->getErrorMsg() );
				return false;
			}
		}

		return true;
	}
	/**
	 * Method to delete record(s)
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	function delete()
	{
		$cids = JRequest::getVar( 'cid', array(0), 'post', 'array' );

		$row =& $this->getTable();

		if (count( $cids ))
		{
			foreach($cids as $cid) {
				if (HsConfigHelper::isSiteConfig($cid))
				{
					$this->setError( JText::_('Site Configuration cannot be deleted').'.');
					return false;
				}
				if (HsConfigHelper::isPublished( $cid ))
				{
					$this->setError( JText::_('Configuration must be unpublished before deletion').'.');
					return false;
				}

				if (!$row->delete( $cid )) {
					$this->setError( $row->getErrorMsg() );
					return false;
				}
			}
		}
		return true;
	}

	/**
	 * Method to delete record(s)
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	function publish()
	{
		$cids = JRequest::getVar( 'cid', array(0), 'post', 'array' );

		if (count( $cids ))
		{
			foreach($cids as $cid)
			{
				$this->setId( $cid );
				$this->getData();
				$registry = new JRegistry();
				$registry->loadINI($this->_data->params);
				$hs_base = JURI::root(true).'/plugins/content/highslide/';

				//	generate the configuration files
				if (!$this->_savecss( $registry, $cid, $hs_base, $this->_data->css ))
					return false;
				if (!$this->_savejs( $registry, $cid, $hs_base, $this->_data->overlayhtml ))
					return false;
			}

			$datenow =& JFactory::getDate();
			$row =& $this->getTable();
			JArrayHelper::toInteger( $cid );
			$k			= $row->_tbl_key;

			$cidx = $k . ' = ' . implode( ' OR ' . $k . '=', $cids );

			$query = 'UPDATE '. $row->_tbl
			. ' SET published = ' . (int) 1
			. ', publish_tmst = '. "'". $datenow->toMySQL() ."'"
			. ' WHERE ('.$cidx.')'
			;

			$row->_db->setQuery( $query );
			if (!$row->_db->query())
			{
				$row->setError($row->_db->getErrorMsg());
				return false;
			}
		}
		return true;
	}

	/**
	 * Method to delete record(s)
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	function publishOne( $id )
	{
		$this->setId( $id );
		$this->getData();
		$registry = new JRegistry();
		$registry->loadINI($this->_data->params);
		$hs_base = JURI::root(true).'/plugins/content/highslide/';

		//	generate the configuration files
		if (!$this->_savecss( $registry, $id, $hs_base, $this->_data->css ))
			return false;
		if (!$this->_savejs( $registry, $id, $hs_base, $this->_data->overlayhtml ))
			return false;

		$datenow =& JFactory::getDate();
		$row =& $this->getTable();

		$query = 'UPDATE '. $row->_tbl
		. ' SET published = ' . (int) 1
		. ', publish_tmst = '. "'". $datenow->toMySQL() ."'"
		. ' WHERE id = ' .$id.' '
		;

		$row->_db->setQuery( $query );
		if (!$row->_db->query())
		{
			$row->setError($row->_db->getErrorMsg());
			return false;
		}
		return true;
	}

	/**
	 * Method to delete record(s)
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	function unpublish()
	{
		$cids = JRequest::getVar( 'cid', array(0), 'post', 'array' );

		if (count( $cids ))
		{
			foreach($cids as $cid)
			{
				if (!$this->_delete( HsConfigHelper::createJsName( $cid )))
					return false;
				if (!$this->_delete( HsConfigHelper::createCssName( $cid )))
					return false;
			}
			$row =& $this->getTable();
			$row->publish( $cids, false );
		}
		return true;
	}

	function _getVer(){
		return ('1.0.3');
	}

	/**
	 * Save a CSS stylesheet for the given id's configuration
	 *
	 * @param mixed $registry	configuration parameters
	 * @param mixed $id			associated configuration id
	 * @param mixed $hs_base	base path of highslide installation
	 * @return 					none. errors will be thrown
	 */
	function _savecss( &$registry, $id, $hs_base, &$csstext )
	{

		$filelines = array();

		if (HsConfigHelper::isSiteConfig($id) )
		{
			$filelines[] = '/* Highslide site styles */';
		}
		else
		{
			$filelines[] = '/* Highslide article specific styles */';
		}

		$fname = HsConfigHelper::createCssName( $id );
		$jnow		=& JFactory::getDate();

		$filelines[] = '/* DO NOT EDIT. Generated on ' . $jnow->toFormat() . ' (GMT) by the Highslide Configuration Component ' . $this->_getVer() . ' */';
		$filelines[] = '';

		//	define the highslide class
		$filelines[] = '.highslide {';
		$filelines[] = '	outline: none;';
		$filelines[] = '}';

		//	THunbnail visibility
		$filelines[] = '.highslide-active-anchor img {';
		$filelines[] = '	visibility: ' . $registry->getValue('thumbNail') . ';';
		$filelines[] = '}';


		$filelines[] = '.highslide img {';
		$filelines[] = '	outline: none;';
		$filelines[] = '	cursor: url(' . $hs_base . 'graphics/' . $registry->getValue('expandCursor') . '), pointer;';
		$filelines[] = '}';

		$filelines[] = '.highslide-overlay {';
		$filelines[] = '	display: none;';
		$filelines[] = '}';

		$filelines[] = '.highslide-wrapper {';
		$filelines[] = '}';

		$filelines[] = '.highslide-image-blur {';
		$filelines[] = '}';

		$filelines[] = '.highslide-caption {';
		$filelines[] = '	display: none;';
		$filelines[] = '}';

		// Opacity dimming
	   	$dimcolor = $registry->getValue('backgroundDimmingColor');
	   	if ($dimcolor == '')
	  	{
	   		$dimcolor = 'black';
	   	}
	   	$filelines[] = 	'.highslide-dimming {';
	   	$filelines[] = 	'	position: absolute;';
	   	$filelines[] = 	'	width: 100%;';
	   	$filelines[] = 	'	background: ' . $dimcolor . ';';
	   	$filelines[] = 	'}';

		$filelines[] = '.highslide-html-content {';
		$filelines[] = '	position: absolute;';
		$filelines[] = '    display: none;';
		$filelines[] = '}';

		if ($csstext != "")
		{
			$filelines[] = '/* Beginning of inserted CSS configuration parameters */';
			$newtext = eregi_replace( "url( )*\(( )*([^( ]+)", "url(" . JURI::root(true) . "\\3", $csstext );
			$filelines[] = $newtext;
			$filelines[] = '/* End of inserted CSS configuration parameters */';
		}

		// these must be the last highslide-related css entries
		$filelines[] = '.highslide-display-block {';
		$filelines[] = '	display: block;';
		$filelines[] = '}';

		$filelines[] = '.highslide-display-none {';
		$filelines[] = '	display: none;';
		$filelines[] = '}';

		$filedata = implode( "\r\n", $filelines );

		return ($this->_write( $fname, $filedata ));
	}

	/**
	 * Save a Javascript file for the given id's configuration
	 *
	 * @param mixed $registry	configuration parameters
	 * @param mixed $id			associated configuration id
	 * @param mixed $hs_base	base path of highslide installation
	 * @return 					none. errors will be thrown
	 */
	function _savejs( &$registry, $id, $hs_base, &$overlayhtml )
	{

		$filelines = array();

		if (HsConfigHelper::isSiteConfig($id) )
		{
			$filelines[] = '// Highslide site settings';
		}
		else
		{
			$filelines[] = '// Highslide article specific settings';
		}

		$fname = HsConfigHelper::createJsName( $id );
		$jnow		=& JFactory::getDate();

		$filelines[] = '// DO NOT EDIT. Generated on ' . $jnow->toFormat() . ' (GMT) by the Highslide Configuration Component ' . $this->_getVer();
		$filelines[] = '';

		// Credits display
		$filelines[] = "hs.showCredits = " . $registry->getValue('showCredits') ."e;";
		$filelines[] = "hs.graphicsDir = '".$hs_base."graphics/';";

		// outlineType: outer-glow, rounded-white
		$filelines[] = "hs.outlineType = '" . $registry->getValue('outlineType') . "';";
		if (is_numeric($registry->getValue('outlineStartOffset')))
		{
	    	$filelines[] = "hs.outlineStartOffset = " . $registry->getValue('outlineStartOffset') . ";";
		}
		$filelines[] = "hs.outlineWhileAnimating = " . $registry->getValue('outlineWhileAnimating') . "e;";

		// Caption
		$filelines[] = "hs.captionEval = '" . $registry->getValue('captionEval') . "';";

		// Loading Text
		$filelines[] = "hs.loadingText = '" . JText::_($registry->getValue('loadingText')) . "';";
		if ($registry->getValue('loadingTitle') != '')
		{
			$filelines[] = "hs.loadingTitle = '" . JText::_($registry->getValue('loadingTitle')) . "';";
		}
		if (is_numeric($registry->getValue('loadingOpacity')))
		{
	    	$filelines[] = "hs.loadingOpacity = " . $registry->getValue('loadingOpacity') . ";";
		}

		// Dimming background opacity
		if (is_numeric($registry->getValue('dimmingOpacity')))
		{
	    	$filelines[] = "hs.dimmingOpacity = " . $registry->getValue('dimmingOpacity') . ";";
		}
		if ($registry->getValue('captionId') != '')
		{
			$filelines[] = "hs.captionId = '" . $registry->getValue('captionId') . "';";
		}
		if ($registry->getValue('captionText') != '')
		{
			$filelines[] = "hs.captionText = '" . JText::_($registry->getValue('captionText')) . "';";
		}
		$filelines[] = "hs.padToMinWidth = " . $registry->getValue('padToMinWidth') . "e;";
		if ($registry->getValue('focusTitle') != '')
		{
			$filelines[] = "hs.focusTitle = '" . JText::_($registry->getValue('focusTitle')) . "';";
		}
		if ($registry->getValue('contentId') != '')
		{
			$filelines[] = "hs.contentId = '" . JText::_($registry->getValue('contentId')) . "';";
		}
		if ($registry->getValue('closeText') != '')
		{
			$filelines[] = "hs.closeText = '" . JText::_($registry->getValue('closeText')) . "';";
		}
		if ($registry->getValue('closeTitle') != '')
		{
			$filelines[] = "hs.closeTitle = '" . JText::_($registry->getValue('closeTitle')) . "';";
		}
		if ($registry->getValue('resizeTitle') != '')
		{
			$filelines[] = "hs.resizeTitle = '" . JText::_($registry->getValue('resizeTitle')) . "';";
		}
		if ($registry->getValue('moveText') != '')
		{
			$filelines[] = "hs.moveText = '" . JText::_($registry->getValue('moveText')) . "';";
		}
		if ($registry->getValue('nextText') != '')
		{
			$filelines[] = "hs.nextText = '" . JText::_($registry->getValue('nextText')) . "';";
		}
		if ($registry->getValue('previousText') != '')
		{
			$filelines[] = "hs.previousText = '" . JText::_($registry->getValue('previousText')) . "';";
		}
		if ($registry->getValue('restoreCursor') != '')
		{
			$filelines[] = "hs.restoreCursor = '" . JText::_($registry->getValue('restoreCursor')) . "';";
		}
		if ($registry->getValue('creditsHref') != '')
		{
			$filelines[] = "hs.creditsHref = '" . JText::_($registry->getValue('creditsHref')) . "';";
		}
		if ($registry->getValue('creditsText') != '')
		{
			$filelines[] = "hs.creditsText = '" . JText::_($registry->getValue('creditsText')) . "';";
		}
		if ($registry->getValue('creditsTitle') != '')
		{
			$filelines[] = "hs.creditsTitle = '" . JText::_($registry->getValue('creditsTitle')) . "';";
		}
		if ($registry->getValue('easing') != '')
		{
			if($registry->getValue('easing') == 'null')
			{
				$filelines[] = "hs.easing = '';";
			}
			else
			{
				$filelines[] = "hs.easing = '" . $registry->getValue('easing') . "';";
			}
		}
		if ($registry->getValue('easingClose') != '')
		{
			$filelines[] = "hs.easingClose = '" . $registry->getValue('easingClose') . "';";
		}
		else
		{
			$filelines[] = "hs.easingClose = hs.easing;";
		}
		if ($registry->getValue('objectType') != '')
		{
			$filelines[] = "hs.objectType = '" . $registry->getValue('objectType') . "';";
		}
		if (is_numeric($registry->getValue('fullExpandOpacity')))
		{
	    	$filelines[] = "hs.fullExpandOpacity = " . $registry->getValue('fullExpandOpacity') . ";";
		}
		if (is_numeric($registry->getValue('height')))
		{
	    	$filelines[] = "hs.height = " . $registry->getValue('height') . ";";
		}
		if (is_numeric($registry->getValue('width')))
		{
	    	$filelines[] = "hs.width = " . $registry->getValue('width') . ";";
		}
		if ($registry->getValue('fullExpandTitle') != '')
		{
			$filelines[] = "hs.fullExpandTitle = '" . JText::_($registry->getValue('fullExpandTitle')) . "';";
		}
		if ($registry->getValue('targetX') != '')
		{
			$filelines[] = "hs.targetX = '" . JText::_($registry->getValue('targetX')) . "';";
		}
		if ($registry->getValue('targetY') != '')
		{
			$filelines[] = "hs.targetY = '" . JText::_($registry->getValue('targetY')) . "';";
		}
		if (is_numeric($registry->getValue('marginTop')))
		{
	    	$filelines[] = "hs.marginTop = " . $registry->getValue('marginTop') . ";";
		}
		if (is_numeric($registry->getValue('marginBottom')))
		{
	    	$filelines[] = "hs.marginBottom = " . $registry->getValue('marginBottom') . ";";
		}
		if (is_numeric($registry->getValue('marginLeft')))
		{
	    	$filelines[] = "hs.marginLeft = " . $registry->getValue('marginLeft') . ";";
		}
		if (is_numeric($registry->getValue('marginRight')))
		{
	    	$filelines[] = "hs.marginRight = " . $registry->getValue('marginRight') . ";";
		}
		if (is_numeric($registry->getValue('minHeight')))
		{
	    	$filelines[] = "hs.minHeight = " . $registry->getValue('minHeight') . ";";
		}
		if (is_numeric($registry->getValue('minWidth')))
		{
	    	$filelines[] = "hs.minWidth = " . $registry->getValue('minWidth') . ";";
		}
		if (is_numeric($registry->getValue('objectHeight')))
		{
	    	$filelines[] = "hs.objectHeight = " . $registry->getValue('objectHeight') . ";";
		}
		if (is_numeric($registry->getValue('objectWidth')))
		{
	    	$filelines[] = "hs.objectWidth = " . $registry->getValue('objectWidth') . ";";
		}
		if (is_numeric($registry->getValue('numberOfImagesToPreload')))
		{
	    	$filelines[] = "hs.numberOfImagesToPreload = " . $registry->getValue('numberOfImagesToPreload') . ";";
		}
		if ($registry->getValue('transitions') != '')
		{
			$filelines[] = "hs.transitions = [" . JText::_($registry->getValue('transitions')) . "];";
		}

		$filelines[] = "hs.objectLoadTime = '" . $registry->getValue('objectLoadTime') . "';";
		$filelines[] = "hs.fullExpandPosition = '" . $registry->getValue('fullExpandPosition') . "';";
		$filelines[] = "hs.align = '" . $registry->getValue('align') . "';";
		$filelines[] = "hs.anchor = '" . $registry->getValue('anchor') . "';";
		$filelines[] = "hs.allowSizeReduction = " . $registry->getValue('allowSizeReduction') . "e;";
		$filelines[] = "hs.fadeInOut = " . $registry->getValue('fadeInOut') . "e;";
		$filelines[] = "hs.allowMultipleInstances = " . $registry->getValue('allowMultipleInstances') . "e;";
		$filelines[] = "hs.allowWidthReduction = " . $registry->getValue('allowWidthReduction') . "e;";
		$filelines[] = "hs.allowHeigthReduction = " . $registry->getValue('allowHeightReduction') . "e;";
		$filelines[] = "hs.blockRightClick = " . $registry->getValue('blockRightClick') . "e;";
		$filelines[] = "hs.enableKeyListener = " . $registry->getValue('enableKeyListener') . "e;";
		$filelines[] = "hs.cacheAjax = " . $registry->getValue('cacheAjax') . "e;";
		$filelines[] = "hs.preserveContent = " . $registry->getValue('preserveContent') . "e;";
		if (is_numeric($registry->getValue('captionSlideSpeed')))
		{
			$filelines[] = "hs.captionSlideSpeed = " . $registry->getValue('captionSlideSpeed') . ";";
		}
		if (is_numeric($registry->getValue('spaceForCaption')))
		{
			$filelines[] = "hs.spaceForCaption = " . $registry->getValue('spaceForCaption') . ";";
		}
		if (is_numeric($registry->getValue('dragSensitivity')))
		{
			$filelines[] = "hs.dragSensitivity = " . $registry->getValue('dragSensitivity') . ";";
		}
		if (is_numeric($registry->getValue('dimmingDuration')))
		{
			$filelines[] = "hs.dimmingDuration = " . $registry->getValue('dimmingDuration') . ";";
		}
		if (is_numeric($registry->getValue('expandDuration')))
		{
			$filelines[] = "hs.expandDuration = " . $registry->getValue('expandDuration') . ";";
		}
		if (is_numeric($registry->getValue('expandSteps')))
		{
			$filelines[] = "hs.expandSteps = " . $registry->getValue('expandSteps') . ";";
		}
		if (is_numeric($registry->getValue('restoreCursorDuration')))
		{
			$filelines[] = "hs.restoreCursorDuration = " . $registry->getValue('restoreCursorDuration') . ";";
		}
		if (is_numeric($registry->getValue('restoreCursorSteps')))
		{
			$filelines[] = "hs.restoreCursorSteps = " . $registry->getValue('restoreCursorSteps') . ";";
		}
		if (is_numeric($registry->getValue('zIndexCounter')))
		{
			$filelines[] = "hs.zIndexCounter = " . $registry->getValue('zIndexCounter') . ";";
		}
		if ($registry->getValue('restoreTitle') != '')
		{
			$filelines[] = "hs.restoreTitle = '" . JText::_($registry->getValue('restoreTitle')) . "';";
		}
		if($registry->getValue("mouseHoverAction") != "")
		{
			if ($registry->getValue("mouseHoverAction") == "focus")
			{
				$filelines[] = "hs.Expander.prototype.onMouseOver = function (sender) { ";
				$filelines[] = "   sender.focus();";
				$filelines[] = "};";
			}
			if ($registry->getValue("mouseHoverAction") == "close")
			{
				$filelines[] = "hs.Expander.prototype.onMouseOut = function (sender) { ";
				$filelines[] = "   sender.close();";
				$filelines[] = "};";
			}
		}
		if ($registry->getValue("modalWhenDimmed") == "yes")
		{
			$filelines[] = "hs.onDimmerClick = function () { ";
			$filelines[] = "   return false;";
			$filelines[] = "};";
		}
		if ($registry->getValue("ovOverlayId") != "")
		{
			if ($overlayhtml != "")
			{
				$overlayhtml = ereg_replace("[\n|\r]", "", $overlayhtml );
				$overlayhtml = ereg_replace("'", "\'", $overlayhtml );
				$filelines[] = "hs.Expander.prototype.onBeforeExpand = function(sender, e)";
				$filelines[] = "{";
				$filelines[] = "	if (document.getElementById('" . $registry->getValue('ovOverlayId') ."') == null)";
				$filelines[] = "	{";
				$filelines[] = "		var div = document.createElement('div');";
				$filelines[] = "		div['innerHTML'] = '" . $overlayhtml . "';";
				$filelines[] = "		div['id'] = '" . $registry->getValue('ovOverlayId') . "';";
				$filelines[] = "		div['className'] = 'highslide-overlay';";
				$filelines[] = "		sender.a.appendChild( div );";
				$filelines[] = "	}";
				$filelines[] = "	return true;";
				$filelines[] = "}";
				$filelines[] = "hs.Expander.prototype.onCreateOverlay = function(sender, e)";
				$filelines[] = "{";
				$filelines[] = "    if (e.overlay.innerHTML.indexOf( '{thumbalt}', 0 ) != -1) {";
				$filelines[] = "		e.overlay.innerHTML = e.overlay.innerHTML.replace('{thumbalt}', sender.thumb.alt);";
				$filelines[] = "	}";
				$filelines[] = "    if (e.overlay.innerHTML.indexOf( '{thumbtitle}', 0 ) != -1) {";
				$filelines[] = "		e.overlay.innerHTML = e.overlay.innerHTML.replace('{thumbtitle}', sender.thumb.title);";
				$filelines[] = "	}";
				$filelines[] = "    if (e.overlay.innerHTML.indexOf( '{popuptitle}', 0 ) != -1) {";
				$filelines[] = "		e.overlay.innerHTML = e.overlay.innerHTML.replace('{popuptitle}', sender.a.title);";
				$filelines[] = "	}";
				$filelines[] = "}";
			}
			$filelines[] = "hs.registerOverlay(";
			$filelines[] = "{";
			if ($registry->getValue("ovThumbnailId") == "")
			{
				$filelines[] = "    thumbnailId: null,";
			}
			else
			{
				$filelines[] = "    thumbnailId: '" . $registry->getValue("ovThumbnailId") . "',";
			}
			if ($registry->getValue("ovSlideshowGroup") != "")
			{
				$filelines[] = "    slideshowGroup: '" . $registry->getValue("ovSlideshowGroup") . "',";
			}
			$filelines[] = "    fade: " . $registry->getValue("ovFade") . ",";
			$filelines[] = "    overlayId: '" . $registry->getValue("ovOverlayId") . "',";
			$filelines[] = "    position: '" . $registry->getValue("ovPosition") . "',";
			$filelines[] = "    hideOnMouseOut: " . $registry->getValue("ovHideOnMouseOut") . "e,";
			$filelines[] = "    opacity: " . $registry->getValue("ovOpacity") . ",";
			$filelines[] = "    useOnHtml: " . $registry->getValue("ovUseOnHtml") . "e";
			$filelines[] = "});";
		}
		$filelines[] = "hs.Expander.prototype.onAfterExpand = function (sender, e) {";
		$filelines[] = "	if (this.custom != null";
		$filelines[] = "       &&this.custom['overlayId'] != null)";
		$filelines[] = "    {";
		$filelines[] = "		sender.createOverlay( this.custom );";
		$filelines[] = "	}";
		$filelines[] = "}";

		$filelines[] = "hs.Expander.prototype.onInit = function (sender, e)";
		$filelines[] = "{";
		$filelines[] = "	if (this.custom != null";
		$filelines[] = "	   &&this.custom['swffile'] != null";
		$filelines[] = "	   &&this.swfObject == null";
		$filelines[] = "	   )";
		$filelines[] = "	{";
		$filelines[] = "		this.swfObject = new SWFObject( this.custom['swffile']";
		$filelines[] = "		                              , this.custom['swfobjectId']";
		$filelines[] = "		                              , this.custom['swfwidth']";
		$filelines[] = "		                              , this.custom['swfheight']";
		$filelines[] = "		                              , this.custom['swfversion']";
		$filelines[] = "		                              , this.custom['swfbgcolor']";
		$filelines[] = "									  );";
		$filelines[] = "		this.swfObject.addParam('wmode', 'transparent' );";
		$filelines[] = "	}";
		$filelines[] = "	return true;";
		$filelines[] = "}";

		$filedata = implode( "\r\n", $filelines );

		return ($this->_write( $fname, $filedata ) );
	}

	/**
	 * Delete the specified file if it exists
	 *
	 * @param mixed $fname		full path name of file to be deleted
	 * @return 					none, errors will be thrown
	 */
	function _delete( $fname )
	{
		jimport('joomla.filesystem.path');
		jimport('joomla.filesystem.file');

		if (JPath::isOwner($fname) && !JPath::setPermissions($fname, '0644'))
		{
			JError::raiseNotice('SOME_ERROR_CODE', 'Could not make ' . $fname . ' writable');
		}

		if (JFILE::exists( $fname))
		{
			JFILE::delete( $fname );
		}

		// Try to make configuration.php unwriteable
		if (JPath::isOwner($fname) && !JPath::setPermissions($fname, '0444'))
		{
			if (JPath::isOwner($fname) && !JPath::setPermissions($fname, '0444'))
			{
				JError::raiseNotice('SOME_ERROR_CODE', 'Could not make ' . $fname . ' unwritable');
			}
		}
		return true;
	}

	/**
	 * Create the specified file.
	 *
	 * @param mixed $fname		full path name of file to be written
	 * @param mixed $data		data to be written to the file
	 * @return 					none, errors will be thrown
	 */
	function _write( &$fname, &$data )
	{
		jimport('joomla.filesystem.path');
		jimport('joomla.filesystem.file');

		if (JPath::isOwner($fname) && !JPath::setPermissions($fname, '0644'))
		{
			JError::raiseNotice('SOME_ERROR_CODE', 'Could not make ' . $fname . ' writable');
		}

		JFILE::write( $fname, $data );

		// Try to make configuration.php unwriteable
		if (JPath::isOwner($fname) && !JPath::setPermissions($fname, '0444'))
		{
			if (JPath::isOwner($fname) && !JPath::setPermissions($fname, '0444'))
			{
				JError::raiseNotice('SOME_ERROR_CODE', 'Could not make ' . $fname . ' unwritable');
			}
		}
		return true;
	}
}
?>
