<?php
/**
 * Highslide Configuration View for Highslide Configuration Component
 *
 * @license		GNU/GPL
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport( 'joomla.application.component.view' );

/**
 * HsConfig View
 */
class HsConfigsViewHsConfig extends JView
{
	/**
	 * display method of HsConfig view
	 * @return void
	 **/
	function display($tpl = null)
	{
		// Load tooltips behavior
		JHTML::_('behavior.tooltip');
		JHTML::stylesheet('icons.css', 'administrator/components/com_hsconfig/css/');

		//get the hsconfig
		$hsconfig	=& $this->get('Data');
		$isNew		= ($hsconfig->id == 0);
		$params		= new JParameter($hsconfig->params, JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_hsconfig' . DS . 'hsconfig.xml');

		$text = $isNew ? JText::_( 'New' ) : JText::_( 'Edit' );
		JToolBarHelper::title(   JText::_( 'Highslide JS Configuration' ).': <small><small>[ ' . $text.' ]</small></small>', 'config.png' );
		JToolBarHelper::custom('pubsave','savepublish.png', 'savepublish_f2.png', 'Save/Publish', false, true);
		JToolBarHelper::custom('pubapply','applypublish.png', 'applypublish_f2.png', 'Apply/Publish', false, true);
		JToolBarHelper::save();

		if ($isNew)
		{
			JToolBarHelper::cancel();
		}
		else
		{
			// for existing items changes can be applied
			JToolBarHelper::apply();
			// for existing items the button is renamed `close`
			JToolBarHelper::cancel( 'close', 'Close' );
		}

		$this->assignRef('hsconfig', $hsconfig);
		$this->assignRef('params', $params);
		if ($isNew)
		{
			$articlelist = $this->get('ArticleList');
			$this->assignRef('articlelist', $articlelist);
		}
		parent::display($tpl);
	}
}
