<?php
/**
* FLEXIcontent Advanced Link for JCE 2.1 (jce_advlink_flexi_1.5)
* @version		$Id: content.php 001 2011-08-28 14:50:33Z Rehne $
* Based on "joomlalinks" found in JCE's core distribution. Modified by Rene Bz
* to support Flexicontent
* @author		Ryan Demmer
* @copyright    Copyright (C) 2008 - 2009 Ryan Demmer. All rights reserved.
* @author		Rene Bz
* copyright(C) 	Copyright (C) 2007 - 2011 Rene Bz - www.nettdotkomm.de
* @author		Emmanuel Danan
* @license      GNU/GPL
* JCE/FLEXIcontent Advanced Link is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/
// no direct access
defined( '_WF_EXT' ) or die( 'Restricted access' );

$fparams =& JComponentHelper::getParams('com_flexicontent');
if (!defined('FLEXI_SECTION')) define('FLEXI_SECTION', $fparams->get('flexi_section'));
if (!defined('FLEXI_ACCESS')) define('FLEXI_ACCESS', (JPluginHelper::isEnabled('system', 'flexiaccess') && version_compare(PHP_VERSION, '5.0.0', '>')) ? 1 : 0);

class FlexicontentLinksContent extends JObject
{
	var $_option = 'com_flexicontent';
	
	var $_task = 'category';
	
	/**
	* Constructor activating the default information of the class
	*
	* @access	protected
	*/
	function __construct($options = array()){
	}

	/**
	 * Returns a reference to a editor object
	 *
	 * This method must be invoked as:
	 * 		<pre>  $browser =JContentEditor::getInstance();</pre>
	 *
	 * @access	public
	 * @return	JCE  The editor object.
	 * @since	1.5
	 */
	function &getInstance()
	{
		static $instance;

		if ( !is_object( $instance ) ){
			$instance = new FlexicontentLinksContent();
		}
		return $instance;
	}
	
	public function getOption()
	{
		return $this->_option;
	}
	
	public function getTask()
	{
		return $this->_task;
	}
	
	public function getList()
	{
		$wf = WFEditorPlugin::getInstance();
		
		if ($wf->checkAccess('links.flexicontentlinks.content', 1)) {
			return '<li id="index.php?option=com_flexicontent&task=category"><div class="tree-row"><div class="tree-image"></div><span class="folder flexicontent nolink"><a href="javascript:;">' . JText::_('Flexicontent Content') . '</a></span></div></li>';
		}
	}
	
	function getLinks($args)
	{		
		$mainframe = JFactory::getApplication();
		$wf = WFEditorPlugin::getInstance();
		
		require_once(JPATH_SITE .DS. 'components' .DS. 'com_flexicontent' .DS. 'helpers' .DS. 'route.php');

		$items 		= array();
		$view		= isset($args->view) ? $args->view : '';
		
		switch ($view) {
		
		default:
			$categories	= self::_getFlexicontentCategories();
			foreach ($categories as $category) {
				$items[] = array(
					// Modified to fix use of flexicontent routing functions
					//'id'		=>	FlexicontentHelperRoute::getCategoryRoute($category->slug),
					'id'		=>	FlexicontentHelperRoute::getCategoryRoute($category->id),
					'name'		=>	$category->title,
					'class'		=>	'folder flexicontent'
				);
			}
			break;
			
		case 'category':
			$categories	= self::_getFlexicontentCategories($args->cid);
			$itemlist = self::_getFlexicontentItems($args->cid);
			foreach ($categories as $category) {
				$items[] = array(
					// Modified to fix use of flexicontent routing functions
					//'id'		=>	FlexicontentHelperRoute::getCategoryRoute($category->slug),
					'id'		=>	FlexicontentHelperRoute::getCategoryRoute($category->id),
					'name'		=>	$category->title,
					'class'		=>	'folder flexicontent'
				);
			}
			foreach ($itemlist as $item) {
				$items[] = array(
					// Modified to fix use of flexicontent routing functions
					//'id'		=>	FlexicontentHelperRoute::getItemRoute($item->slug, $item->categoryslug),
					'id'		=>	FlexicontentHelperRoute::getItemRoute($item->id, $item->catid),
					'name'		=>	$item->title,
					'class'		=>	($item->icatid == (int)$args->cid) ? 'file' : 'seclink'
				);
			}
			break;
			
		case 'items':
			break;
		}
		return $items;
	}
	
	function _getFlexicontentCategories($parent = 0)
	{
		$db		=& JFactory::getDBO();
		$user	=& JFactory::getUser();
		$wf 		= WFEditorPlugin::getInstance();
		$aid	= (int)$user->get('aid');
		
		// Will create the advanced acl authorisations later
		$and   = FLEXI_ACCESS ? '' : ' AND access <= ' . $aid;
		
		$query 	= 'SELECT id, title, alias,'
				. ' CASE WHEN CHAR_LENGTH(alias) THEN CONCAT_WS(\':\', id, alias) ELSE id END as slug'
				. ' FROM #__categories'
				. ' WHERE published = 1'
				. ' AND section = ' . FLEXI_SECTION
				;
		
		if(version_compare(JVERSION,'1.6.0','ge')) {
			$user	=& JFactory::getUser();
			$query .= ' AND access <= '.(int) $user->get('aid');
		}
		
		$query .=
		' AND parent_id = ' . $db->Quote($parent)
		. $and
		. ' ORDER BY ordering ASC'
		;
		
		$db->setQuery($query);
		return $db->loadObjectList();
	}
	
	function _getFlexicontentItems($cid = 0)
	{
		$db		=& JFactory::getDBO();
		$user	=& JFactory::getUser();
		$aid	= (int)$user->get('aid');
		
		// Will create the advanced acl authorisations later
		$and   = FLEXI_ACCESS ? '' : ' AND c.access <= ' . $aid;
		$and  .= FLEXI_ACCESS ? '' : ' AND i.access <= ' . $aid;
		
		// Check if it's usefull to implement authorisations here as authors can theoritically
		// create links even if they can't access to them
		$query	= 'SELECT i.*, i.title AS ititle, i.catid AS icatid, c.access AS cataccess, c.id AS catid, c.published AS catpublished,'
				. ' CASE WHEN CHAR_LENGTH(i.alias) THEN CONCAT_WS(\':\', i.id, i.alias) ELSE i.id END as slug,'
				. ' CASE WHEN CHAR_LENGTH(c.alias) THEN CONCAT_WS(\':\', c.id, c.alias) ELSE c.id END as categoryslug'
				. ' FROM #__content AS i'
				. ' LEFT JOIN #__flexicontent_cats_item_relations AS rel ON rel.itemid = i.id'
				. ' LEFT JOIN #__categories AS c ON c.id = rel.catid'
				. $and
				;
		
		if(version_compare(JVERSION,'1.6.0','ge')) {
			$user	=& JFactory::getUser();
			$query .= ' AND access <= '.(int) $user->get('aid');

		}
		
		$query .=
				' WHERE c.id = ' . $db->Quote($cid)
				. ' ORDER BY i.title, rel.ordering, i.ordering ASC'
				;
		;

		$db->setQuery($query);
		return $db->loadObjectList();
	}
	
}	
?>