<?php
/**
* FLEXIcontent Advanced Link for JCE 2.1 (jce_advlink_flexi_1.5)
* @version		$Id: tags.php 001 2011-08-28 14:50:33Z Rehne $
* Based on "joomlalinks" found in JCE's core distribution. Modified by Rene Bz
* to support Flexicontent
* @author		Ryan Demmer
* @copyright    Copyright (C) 2008 - 2009 Ryan Demmer. All rights reserved.
* @author		Rene Bz
* copyright(C) 	Copyright (C) 2007 - 2011 Rene Bz - www.nettdotkomm.de
* @author		Emmanuel Danan
* @license      GNU/GPL
* JCE/FLEXIcontent Advanced Link is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/
// no direct access
defined( '_WF_EXT' ) or die( 'Restricted access' );
$fparams =& JComponentHelper::getParams('com_flexicontent');
if (!defined('FLEXI_SECTION')) define('FLEXI_SECTION', $fparams->get('flexi_section'));
if (!defined('FLEXI_ACCESS')) define('FLEXI_ACCESS', (JPluginHelper::isEnabled('system', 'flexiaccess') && version_compare(PHP_VERSION, '5.0.0', '>')) ? 1 : 0);
class FlexicontentLinksTags extends JObject
{
	var $_option = 'com_flexicontent';
	var $_task = 'tag';
	
	/**
	* Constructor activating the default information of the class
	*
	* @access	protected
	*/
	function __construct($options = array()){
	}

	/**
	 * Returns a reference to a editor object
	 *
	 * This method must be invoked as:
	 * 		<pre>  $browser =JContentEditor::getInstance();</pre>
	 *
	 * @access	public
	 * @return	JCE  The editor object.
	 * @since	1.5
	 */
	function &getInstance()
	{
		static $instance;

		if ( !is_object( $instance ) ){
			$instance = new FlexicontentLinksTags();
		}
		return $instance;
	}
	
	public function getOption()
	{
		return $this->_option;
	}
	
	public function getTask()
	{
		return $this->_task;
	}
	
	public function getList()
	{
		$wf = WFEditorPlugin::getInstance();
		$list = '';
		if ($wf->checkAccess('links.flexicontentlinks.tags', '1')) {
			$list = '<li id="index.php?option=com_flexicontent&task=tag"><div class="tree-row"><div class="tree-image"></div><span class="folder tags nolink"><a href="javascript:;">' . JText::_('Flexicontent Tags') . '</a></span></div></li>';
		}
		return $list;	
	}
	
	function _getFlexicontentTags()
	{
		$db		=& JFactory::getDBO();
		$user	=& JFactory::getUser();

		$query = 'SELECT t.name, t.id,'
		. ' CASE WHEN CHAR_LENGTH(t.alias) THEN CONCAT_WS(\':\', t.id, t.alias) ELSE t.id END as slug'
		. ' FROM #__flexicontent_tags AS t'
		. ' WHERE published = 1'
		. ' ORDER BY name ASC'
		;

		$db->setQuery($query);
		return $db->loadObjectList();
	}
	
	function _getFlexicontentItems($tag = '')
	{
		$db		=& JFactory::getDBO();

		$tagEscaped = $db->quote($tag);

		$query = 'SELECT t.name, t.id,'
		. ' CASE WHEN CHAR_LENGTH(t.alias) THEN CONCAT_WS(\':\', t.id, t.alias) ELSE t.id END as slug'
		. ' FROM #__flexicontent_tags AS t'
		. ' WHERE t.published = 1'
		;

		if(version_compare(JVERSION, '1.6.0', 'ge')) {
			$user	=& JFactory::getUser();
			$query .= "\nAND i.access <=".(int) $user->get('aid');
		}
		
		$query .= "\nORDER BY `i`.`title`, `i`.`created` ASC";

		$db->setQuery($query);
		return $db->loadObjectList();
	}
		
	function getLinks($args)
	{	
			
		$mainframe = JFactory::getApplication();
		$wf = WFEditorPlugin::getInstance();
		
		require_once(JPATH_SITE .DS. 'components' .DS. 'com_flexicontent' .DS. 'helpers' .DS. 'route.php');

		$items 		= array();
		$view		= isset($args->view) ? $args->view : '';
		
		switch ($view) {
		
		default:
			$tags	= self::_getFlexicontentTags();
			foreach ($tags as $tag) {
				$items[] = array(
					'id'		=>	FlexicontentHelperRoute::getTagRoute($tag->slug),
					'name'		=>	$tag->name,
					'class'		=>	'file flexitag'
				);
			}
			break;
			
		case 'itemlist':
			$itemlist = self::_getFlexicontentItems($args->tag);
			foreach ($itemlist as $item) {
				$items[] = array(
					'id'		=>	FlexicontentHelperRoute::getItemRoute($item->id, $args->id),
					'name'		=>	$item->title,
					'class'		=>	($content->icatid == (int)$args->cid) ? 'file' : 'seclink'
				);
			}
			break;
			
		case 'item':
			break;
		}
		return $items;
	}
}
?>